/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui;

import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.decoration.UITooltip;
import net.malisis.core.client.gui.element.GuiShape;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.font.FontRenderOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.renderer.icon.GuiIcon;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IGuiIconProvider;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.core.helpers.Strings;
import org.lwjgl.opengl.GL11;

public class GuiRenderer
extends MalisisRenderer<TileEntity> {
    public static RenderItem itemRenderer = Minecraft.getMinecraft().getRenderItem();
    public UIComponent<?> currentComponent;
    private int scaleFactor;
    private boolean ignoreScale = false;
    public int mouseX;
    public int mouseY;
    private GuiTexture defaultGuiTexture = new GuiTexture(new ResourceLocation("malisiscore", "textures/gui/gui.png"), 300, 100);
    private GuiTexture currentTexture;
    private static GuiShape rectangle = new SimpleGuiShape();

    public GuiTexture getDefaultTexture() {
        return this.defaultGuiTexture;
    }

    public void setDefaultTexture(GuiTexture texture) {
        this.defaultGuiTexture = texture;
    }

    public void setScaleFactor(int factor) {
        this.scaleFactor = factor;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public void setIgnoreScale(boolean ignore) {
        this.ignoreScale = ignore;
    }

    public boolean isIgnoreScale() {
        return this.ignoreScale;
    }

    public void set(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.partialTick = partialTicks;
    }

    @Override
    public void prepare(RenderType renderType, double ... data) {
        this._initialize();
        this.renderType = renderType;
        this.buffer = Tessellator.getInstance().getBuffer();
        this.currentTexture = null;
        this.bindDefaultTexture();
        if (this.ignoreScale) {
            GlStateManager.pushMatrix();
            GlStateManager.scale((float)(1.0f / (float)this.scaleFactor), (float)(1.0f / (float)this.scaleFactor), (float)1.0f);
        }
        this.enableBlending();
        this.startDrawing();
    }

    @Override
    public void clean() {
        this.draw();
        if (this.ignoreScale) {
            GlStateManager.popMatrix();
        }
        this.reset();
    }

    @Override
    public void next() {
        super.next();
        this.bindDefaultTexture();
    }

    public void bindTexture(GuiTexture texture) {
        if (texture == null || texture == this.currentTexture) {
            return;
        }
        Minecraft.getMinecraft().getTextureManager().bindTexture(texture.getResourceLocation());
        this.currentTexture = texture;
    }

    public void bindDefaultTexture() {
        this.bindTexture(this.defaultGuiTexture);
    }

    @Override
    public void applyTexture(Shape shape, RenderParameters params) {
        Icon icon = params.icon.get();
        if (icon == null) {
            IIconProvider iconProvider = this.getIconProvider(params);
            if (iconProvider == null) {
                return;
            }
            icon = iconProvider instanceof IGuiIconProvider ? ((IGuiIconProvider)iconProvider).getIcon(this.currentComponent) : iconProvider.getIcon();
        }
        boolean isGuiIcon = icon instanceof GuiIcon;
        Face[] faces = shape.getFaces();
        for (int i = 0; i < faces.length; ++i) {
            faces[i].setTexture(isGuiIcon ? ((GuiIcon)icon).getIcon(i) : icon, false, false, false);
        }
    }

    @Override
    protected IIconProvider getIconProvider(RenderParameters params) {
        if (params.iconProvider.get() != null) {
            return params.iconProvider.get();
        }
        if (this.currentComponent.getIconProvider() != null) {
            return this.currentComponent.getIconProvider();
        }
        return null;
    }

    @Override
    public void applyTexture(Face face, RenderParameters params) {
    }

    public void drawScreen(UIContainer<?> container, int mouseX, int mouseY, float partialTick) {
        if (container == null) {
            return;
        }
        this.set(mouseX, mouseY, partialTick);
        this.prepare(RenderType.GUI, new double[0]);
        container.draw(this, mouseX, mouseY, partialTick);
        this.clean();
    }

    public void drawShape(GuiShape shape, RenderParameters params) {
        if (shape == null) {
            return;
        }
        shape.translate(this.currentComponent.screenX(), this.currentComponent.screenY(), this.currentComponent.getZIndex());
        shape.applyMatrix();
        this.applyTexture(shape, params);
        for (Face face : shape.getFaces()) {
            this.drawFace(face, params);
        }
    }

    public void drawRectangle(int x, int y, int z, int width, int height, int color, int alpha) {
        this.drawRectangle(x, y, z, width, height, color, alpha, true);
    }

    public void drawRectangle(int x, int y, int z, int width, int height, int color, int alpha, boolean relative) {
        if (relative && this.currentComponent != null) {
            x += this.currentComponent.screenX();
            y += this.currentComponent.screenY();
            z += this.currentComponent.getZIndex();
        }
        rectangle.resetState();
        rectangle.setSize(width, height);
        rectangle.setPosition(x, y);
        GuiRenderer.rectangle.getFaces()[0].getParameters().colorMultiplier.set(color);
        GuiRenderer.rectangle.getFaces()[0].getParameters().alpha.set(alpha);
        GlStateManager.pushAttrib();
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)z);
        this.disableTextures();
        this.enableBlending();
        this.drawShape(rectangle);
        this.next();
        this.enableTextures();
        GlStateManager.popMatrix();
        GlStateManager.popAttrib();
    }

    public void drawTooltip(UITooltip tooltip) {
        if (tooltip != null) {
            this.prepare(RenderType.GUI, new double[0]);
            this.startDrawing();
            tooltip.draw(this, this.mouseX, this.mouseY, this.partialTick);
            this.draw();
            this.clean();
        }
    }

    public void drawText(String text) {
        this.drawText(null, text, 0.0f, 0.0f, 0.0f, null, true);
    }

    public void drawText(String text, float x, float y, float z) {
        this.drawText(null, text, x, y, z, null, true);
    }

    public void drawText(MalisisFont font, String text, FontRenderOptions fro) {
        this.drawText(font, text, 0.0f, 0.0f, 0.0f, fro, true);
    }

    @Override
    public void drawText(MalisisFont font, String text, float x, float y, float z, FontRenderOptions fro) {
        this.drawText(font, text, x, y, z, fro, true);
    }

    public void drawText(MalisisFont font, String text, float x, float y, float z, FontRenderOptions fro, boolean relative) {
        if (relative && this.currentComponent != null) {
            x += (float)this.currentComponent.screenX();
            y += (float)this.currentComponent.screenY();
            z += (float)this.currentComponent.getZIndex();
        }
        super.drawText(font, text, x, y, z, fro);
    }

    public void drawItemStack(ItemStack itemStack) {
        this.drawItemStack(itemStack, 0, 0, null, null, true);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y) {
        this.drawItemStack(itemStack, x, y, null, null, true);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y, Style format) {
        this.drawItemStack(itemStack, x, y, null, format, true);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y, String label) {
        this.drawItemStack(itemStack, x, y, label, null, true);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y, String label, Style format, boolean relative) {
        String formatStr;
        FontRenderer fontRenderer;
        if (itemStack == null) {
            return;
        }
        if (relative && this.currentComponent != null) {
            x += this.currentComponent.screenX();
            y += this.currentComponent.screenY();
        }
        if ((fontRenderer = itemStack.getItem().getFontRenderer(itemStack)) == null) {
            fontRenderer = Minecraft.getMinecraft().fontRendererObj;
        }
        String string = formatStr = format != null ? format.getFormattingCode() : null;
        if (!(label != null || itemStack.stackSize <= 1 && Strings.isEmpty((CharSequence)formatStr))) {
            label = Integer.toString(itemStack.stackSize);
        }
        if (label == null) {
            label = "";
        }
        if (!Strings.isEmpty((CharSequence)formatStr)) {
            label = formatStr + label;
        }
        Tessellator.getInstance().draw();
        RenderHelper.disableStandardItemLighting();
        RenderHelper.enableGUIStandardItemLighting();
        itemRenderer.renderItemIntoGUI(itemStack, x, y);
        itemRenderer.renderItemOverlayIntoGUI(fontRenderer, itemStack, x, y, label);
        RenderHelper.enableStandardItemLighting();
        GlStateManager.enableBlend();
        this.currentTexture = null;
        this.bindDefaultTexture();
        this.startDrawing();
    }

    public void renderPickedItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        GuiRenderer.itemRenderer.zLevel = 100.0f;
        this.prepare(RenderType.GUI, new double[0]);
        this.startDrawing();
        this.drawItemStack(itemStack, this.mouseX - 8, this.mouseY - 8, null, itemStack.stackSize == 0 ? new Style().setColor(TextFormatting.YELLOW) : null, false);
        this.draw();
        GuiRenderer.itemRenderer.zLevel = 0.0f;
        this.clean();
    }

    public void startClipping(ClipArea area) {
        if (area.noClip || area.width() <= 0 || area.height() <= 0) {
            return;
        }
        GL11.glPushAttrib((int)524288);
        GL11.glEnable((int)3089);
        int f = this.ignoreScale ? 1 : this.scaleFactor;
        int x = area.x * f;
        int y = Minecraft.getMinecraft().displayHeight - (area.y + area.height()) * f;
        int w = area.width() * f;
        int h = area.height() * f;
        GL11.glScissor((int)x, (int)y, (int)w, (int)h);
    }

    public void endClipping(ClipArea area) {
        if (area.noClip || area.width() <= 0 || area.height() <= 0) {
            return;
        }
        GL11.glDisable((int)3089);
        GL11.glPopAttrib();
    }
}

