/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import net.malisis.core.MalisisCore;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.component.IKeyListener;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.UISlot;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.inventory.message.InventoryActionMessage;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.font.FontRenderOptions;
import net.malisis.core.util.MouseButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public abstract class MalisisGui
extends GuiScreen {
    public static GuiTexture BLOCK_TEXTURE = new GuiTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
    public static boolean cancelClose = false;
    protected GuiRenderer renderer;
    protected int displayWidth;
    protected int displayHeight;
    protected int currentGuiScale;
    protected ScaledResolution resolution;
    private UIContainer<?> screen;
    protected boolean guiscreenBackground = true;
    protected int lastMouseX;
    protected int lastMouseY;
    protected long lastClickButton = -1L;
    protected long lastClickTime = 0L;
    protected MalisisInventoryContainer inventoryContainer;
    protected boolean isOverlay = false;
    private AnimationRenderer ar;
    protected UIComponent<?> hoveredComponent;
    protected UIComponent<?> focusedComponent;
    protected boolean constructed = false;
    protected Set<IKeyListener> keyListeners = new HashSet<IKeyListener>();
    private boolean debug = false;
    private HashMap<String, Callable<String>> debugMap = new HashMap();

    protected MalisisGui() {
        this.renderer = new GuiRenderer();
        this.screen = new UIContainer(this);
        this.ar = new AnimationRenderer();
        this.ar.autoClearAnimations();
        this.screen.setClipContent(false);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public abstract void construct();

    protected boolean doConstruct() {
        try {
            if (!this.constructed) {
                this.debugMap.clear();
                this.construct();
                this.constructed = true;
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured while constructing " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + e.getMessage());
            MalisisCore.log.error("A problem occured while constructing " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)e);
        }
        return this.constructed;
    }

    public GuiRenderer getRenderer() {
        return this.renderer;
    }

    public void setInventoryContainer(MalisisInventoryContainer container) {
        this.inventoryContainer = container;
    }

    public MalisisInventoryContainer getInventoryContainer() {
        return this.inventoryContainer;
    }

    public GuiTexture getGuiTexture() {
        return this.renderer.getDefaultTexture();
    }

    public long getElapsedTime() {
        return this.ar.getElapsedTime();
    }

    public final void setWorldAndResolution(Minecraft minecraft, int width, int height) {
        super.setWorldAndResolution(minecraft, width, height);
        this.setResolution();
    }

    public void setResolution() {
        boolean set = this.resolution == null;
        set |= this.displayWidth != Display.getWidth() || this.displayHeight != Display.getHeight();
        if (!(set |= this.currentGuiScale != this.mc.gameSettings.guiScale)) {
            return;
        }
        this.displayWidth = Display.getWidth();
        this.displayHeight = Display.getHeight();
        this.currentGuiScale = this.mc.gameSettings.guiScale;
        this.resolution = new ScaledResolution(this.mc);
        this.renderer.setScaleFactor(this.resolution.getScaleFactor());
        this.width = this.renderer.isIgnoreScale() ? this.displayWidth : this.resolution.getScaledWidth();
        this.height = this.renderer.isIgnoreScale() ? this.displayHeight : this.resolution.getScaledHeight();
        this.screen.setSize(this.width, this.height);
    }

    public void addDebug(String name, final Object ... objects) {
        Callable<String> call = objects.length == 1 && objects[0] instanceof Callable ? (Callable<String>)objects[0] : (objects.length > 1 && objects[0] instanceof String ? new Callable<String>(){

            @Override
            public String call() {
                return String.format((String)objects[0], Arrays.copyOfRange(objects, 1, objects.length));
            }
        } : new Callable<String>(){

            @Override
            public String call() {
                return StringUtils.join((Object[])objects, (char)',');
            }
        });
        this.debugMap.put(name, call);
    }

    public void removeDebug(String name) {
        this.debugMap.remove(name);
    }

    protected void addToScreen(UIComponent<?> component) {
        this.screen.add(component);
        component.onAddedToScreen();
    }

    public void clearScreen() {
        this.screen.removeAll();
    }

    public void registerKeyListener(IKeyListener listener) {
        this.keyListeners.add(listener);
    }

    public void unregisterKeyListener(IKeyListener listener) {
        this.keyListeners.remove(listener);
    }

    public UIComponent<?> getComponentAt(int x, int y) {
        UIComponent<?> component = this.screen.getComponentAt(x, y);
        return component == this.screen ? null : component;
    }

    public void handleMouseInput() {
        try {
            super.handleMouseInput();
            int mouseX = Mouse.getEventX() * this.width / this.mc.displayWidth;
            int mouseY = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
            if (this.lastMouseX != mouseX || this.lastMouseY != mouseY) {
                UIComponent<?> component = this.getComponentAt(mouseX, mouseY);
                if (component != null && !component.isDisabled()) {
                    component.onMouseMove(this.lastMouseX, this.lastMouseY, mouseX, mouseY);
                    component.setHovered(true);
                } else {
                    MalisisGui.setHoveredComponent(null, false);
                }
            }
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            int delta = Mouse.getEventDWheel();
            if (delta == 0) {
                return;
            }
            if (delta > 1) {
                delta = 1;
            } else if (delta < -1) {
                delta = -1;
            }
            UIComponent<?> component = this.getComponentAt(mouseX, mouseY);
            if (component != null && !component.isDisabled()) {
                component.onScrollWheel(mouseX, mouseY, delta);
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    protected void mouseClicked(int x, int y, int button) {
        try {
            long time = System.currentTimeMillis();
            UIComponent<?> component = this.getComponentAt(x, y);
            if (component != null && !component.isDisabled()) {
                if ((long)button == this.lastClickButton && time - this.lastClickTime < 250L) {
                    component.onDoubleClick(x, y, MouseButton.getButton(button));
                    this.lastClickTime = 0L;
                } else {
                    component.onButtonPress(x, y, MouseButton.getButton(button));
                }
                component.setFocused(true);
            } else {
                MalisisGui.setFocusedComponent(null, true);
                if (this.inventoryContainer != null && this.inventoryContainer.getPickedItemStack() != null) {
                    MalisisInventoryContainer.ActionType action = button == 1 ? MalisisInventoryContainer.ActionType.DROP_ONE : MalisisInventoryContainer.ActionType.DROP_STACK;
                    MalisisGui.sendAction(action, null, button);
                }
            }
            this.lastClickTime = time;
            this.lastClickButton = button;
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    protected void mouseClickMove(int x, int y, int button, long timer) {
        try {
            if (this.focusedComponent != null) {
                this.focusedComponent.onDrag(this.lastMouseX, this.lastMouseY, x, y, MouseButton.getButton(button));
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    protected void mouseReleased(int x, int y, int button) {
        try {
            UIComponent<?> component;
            if (this.inventoryContainer != null) {
                if (this.inventoryContainer.shouldResetDrag(button)) {
                    MalisisGui.sendAction(MalisisInventoryContainer.ActionType.DRAG_RESET, null, 0);
                    UISlot.buttonRelased = false;
                    return;
                }
                if (this.inventoryContainer.shouldEndDrag(button)) {
                    MalisisGui.sendAction(MalisisInventoryContainer.ActionType.DRAG_END, null, 0);
                    return;
                }
            }
            if ((component = this.getComponentAt(x, y)) != null && !component.isDisabled()) {
                MouseButton mb = MouseButton.getButton(button);
                component.onButtonRelease(x, y, mb);
                if (component == this.focusedComponent) {
                    if (mb == MouseButton.LEFT) {
                        component.onClick(x, y);
                    } else if (mb == MouseButton.RIGHT) {
                        component.onRightClick(x, y);
                    }
                }
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    protected void keyTyped(char keyChar, int keyCode) {
        try {
            boolean ret = false;
            for (IKeyListener listener : this.keyListeners) {
                ret |= listener.onKeyTyped(keyChar, keyCode);
            }
            if (ret) {
                return;
            }
            if (this.focusedComponent != null && !this.keyListeners.contains(this.focusedComponent) && this.focusedComponent.onKeyTyped(keyChar, keyCode)) {
                return;
            }
            if (this.hoveredComponent != null && !this.keyListeners.contains(this.hoveredComponent) && this.hoveredComponent.onKeyTyped(keyChar, keyCode)) {
                return;
            }
            if (MalisisGui.isGuiCloseKey(keyCode) && this.mc.currentScreen == this) {
                this.close();
            }
            if (!MalisisCore.isObfEnv && MalisisGui.isCtrlKeyDown() && (MalisisGui.currentGui() != null || this.isOverlay)) {
                if (keyCode == 19) {
                    this.clearScreen();
                    this.setResolution();
                    this.construct();
                }
                if (keyCode == 32) {
                    this.debug = !this.debug;
                }
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured while handling key typed for " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.ar.animate();
        if (this.renderer.isIgnoreScale()) {
            mouseX = Mouse.getX();
            mouseY = this.height - Mouse.getY() - 1;
        }
        this.update(mouseX, mouseY, partialTicks);
        if (this.guiscreenBackground) {
            this.drawWorldBackground(1);
        }
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        this.renderer.drawScreen(this.screen, mouseX, mouseY, partialTicks);
        if (this.debug) {
            this.renderer.set(mouseX, mouseY, partialTicks);
            this.renderer.prepare(RenderType.GUI, new double[0]);
            int dy = 0;
            int oy = 5;
            FontRenderOptions fro = new FontRenderOptions();
            fro.color = 0xFFFFFF;
            fro.shadow = true;
            this.renderer.drawText(null, "Mouse : " + mouseX + "," + mouseY, 5.0f, dy++ * 10 + oy, 0.0f, fro, false);
            this.renderer.drawText(null, "Focus : " + this.focusedComponent, 5.0f, dy++ * 10 + oy, 0.0f, fro, false);
            this.renderer.drawText(null, "Hover : " + this.hoveredComponent, 5.0f, dy++ * 10 + oy, 0.0f, fro, false);
            for (Map.Entry<String, Callable<String>> entry : this.debugMap.entrySet()) {
                Callable<String> call = entry.getValue();
                try {
                    this.renderer.drawText(null, entry.getKey() + " : " + call.call(), 5.0f, dy++ * 10 + oy, 0.0f, fro, false);
                }
                catch (Exception e) {
                    this.renderer.drawText(null, entry.getKey() + " : " + e.getMessage(), 5.0f, dy++ * 10 + oy, 0.0f, fro, false);
                }
            }
            this.renderer.clean();
        }
        if (this.inventoryContainer != null) {
            ItemStack itemStack = this.inventoryContainer.getPickedItemStack();
            if (itemStack != null) {
                this.renderer.renderPickedItemStack(itemStack);
            } else if (this.hoveredComponent != null && this.hoveredComponent.isHovered()) {
                this.renderer.drawTooltip(this.hoveredComponent.getTooltip());
            }
        } else if (this.hoveredComponent != null && this.hoveredComponent.isHovered()) {
            this.renderer.drawTooltip(this.hoveredComponent.getTooltip());
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public void update(int mouseX, int mouseY, float partialTick) {
    }

    public void updateGui() {
    }

    public void animate(Animation<?> animation) {
        this.animate(animation, 0);
    }

    public void animate(Animation<?> animation, int delay) {
        animation.setDelay((int)this.ar.getElapsedTicks() + delay);
        this.ar.addAnimation(animation);
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    public void display() {
        this.display(false);
    }

    public void display(boolean cancelClose) {
        if (!this.doConstruct()) {
            return;
        }
        MalisisGui.cancelClose = cancelClose;
        Minecraft.getMinecraft().displayGuiScreen((GuiScreen)this);
    }

    public void close() {
        MalisisGui.setFocusedComponent(null, true);
        MalisisGui.setHoveredComponent(null, true);
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.mc.thePlayer != null) {
            this.mc.thePlayer.closeScreen();
        }
        this.mc.displayGuiScreen((GuiScreen)null);
        this.mc.setIngameFocus();
    }

    public void displayOverlay() {
        this.mc = Minecraft.getMinecraft();
        this.isOverlay = true;
        this.setWorldAndResolution(this.mc, 0, 0);
        if (!this.doConstruct()) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void closeOverlay() {
        if (this.mc.currentScreen == this) {
            this.close();
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.onGuiClosed();
    }

    public void onGuiClosed() {
        if (this.inventoryContainer != null) {
            this.inventoryContainer.onContainerClosed((EntityPlayer)this.mc.thePlayer);
        }
    }

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || Minecraft.getMinecraft().currentScreen == this) {
            return;
        }
        this.setResolution();
        this.drawScreen(0, 0, event.getPartialTicks());
    }

    @SubscribeEvent
    public void keyEvent(InputEvent.KeyInputEvent event) {
        if (!this.isOverlay || this.mc.currentScreen == this) {
            return;
        }
        if (Keyboard.getEventKeyState()) {
            this.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
    }

    public static MalisisGui currentGui() {
        return MalisisGui.currentGui(MalisisGui.class);
    }

    public static <T extends MalisisGui> T currentGui(Class<T> type) {
        GuiScreen gui = Minecraft.getMinecraft().currentScreen;
        if (gui == null || !(gui instanceof MalisisGui)) {
            return null;
        }
        try {
            return (T)((Object)((MalisisGui)((Object)type.cast(gui))));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static void sendAction(MalisisInventoryContainer.ActionType action, MalisisSlot slot, int code) {
        if (action == null || MalisisGui.currentGui() == null || MalisisGui.currentGui().inventoryContainer == null) {
            return;
        }
        int inventoryId = slot != null ? slot.getInventoryId() : 0;
        int slotNumber = slot != null ? slot.slotNumber : 0;
        MalisisGui.currentGui().inventoryContainer.handleAction(action, inventoryId, slotNumber, code);
        InventoryActionMessage.sendAction(action, inventoryId, slotNumber, code);
    }

    public static UIComponent<?> getHoveredComponent() {
        return MalisisGui.currentGui() != null ? MalisisGui.currentGui().hoveredComponent : null;
    }

    public static boolean setHoveredComponent(UIComponent<?> component, boolean hovered) {
        MalisisGui gui = MalisisGui.currentGui();
        if (gui == null) {
            return false;
        }
        if (gui.hoveredComponent == component) {
            if (!hovered) {
                gui.hoveredComponent = null;
                return true;
            }
            return false;
        }
        if (hovered) {
            if (gui.hoveredComponent != null) {
                gui.hoveredComponent.setHovered(false);
            }
            gui.hoveredComponent = component;
        }
        return true;
    }

    public static UIComponent<?> getFocusedComponent() {
        return MalisisGui.currentGui() != null ? MalisisGui.currentGui().focusedComponent : null;
    }

    public static boolean setFocusedComponent(UIComponent<?> component, boolean focused) {
        MalisisGui gui = MalisisGui.currentGui();
        if (gui == null) {
            return false;
        }
        if (gui.focusedComponent == component) {
            if (!focused) {
                gui.focusedComponent = null;
                return true;
            }
            return false;
        }
        if (focused) {
            if (gui.focusedComponent != null) {
                gui.focusedComponent.setFocused(false);
            }
            gui.focusedComponent = component;
        }
        return true;
    }

    public static void playSound(SoundEvent sound) {
        MalisisGui.playSound(sound, 1.0f);
    }

    public static void playSound(SoundEvent sound, float level) {
        Minecraft.getMinecraft().getSoundHandler().playSound((ISound)PositionedSoundRecord.getMasterRecord((SoundEvent)sound, (float)level));
    }

    public static boolean isGuiCloseKey(int keyCode) {
        MalisisGui gui = MalisisGui.currentGui();
        return keyCode == 1 || gui != null && gui.inventoryContainer != null && keyCode == gui.mc.gameSettings.keyBindInventory.getKeyCode();
    }
}

