/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.decoration;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;
import net.minecraft.item.ItemStack;

public class UIImage
extends UIComponent<UIImage> {
    private GuiTexture texture;
    private Icon icon = null;
    private ItemStack itemStack;

    public UIImage(MalisisGui gui, GuiTexture texture, Icon icon) {
        super(gui);
        this.iconProvider = new GuiIconProvider(null);
        this.setIcon(texture, icon);
        this.setSize(16, 16);
        this.shape = new SimpleGuiShape();
        this.iconProvider = new GuiIconProvider(null);
    }

    public UIImage(MalisisGui gui, ItemStack itemStack) {
        super(gui);
        this.iconProvider = new GuiIconProvider(null);
        this.setItemStack(itemStack);
        this.setSize(16, 16);
        this.shape = new SimpleGuiShape();
    }

    public UIImage setIcon(Icon icon) {
        this.itemStack = null;
        this.icon = icon != null ? icon : new Icon();
        return this;
    }

    public UIImage setIcon(GuiTexture texture, Icon icon) {
        this.itemStack = null;
        this.icon = icon != null ? icon : new Icon();
        this.texture = texture;
        return this;
    }

    public UIImage setItemStack(ItemStack itemStack) {
        this.icon = null;
        this.texture = null;
        this.itemStack = itemStack;
        this.setSize(16, 16);
        return this;
    }

    public Icon getIcon() {
        return this.iconProvider.getIcon();
    }

    public GuiTexture getTexture() {
        return this.texture;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public UIImage setSize(int width, int height) {
        if (this.itemStack != null) {
            width = 16;
            height = 16;
        }
        return (UIImage)super.setSize(width, height);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.icon != null) {
            ((GuiIconProvider)this.iconProvider).setIcon(this.icon);
            renderer.bindTexture(this.texture);
            renderer.drawShape(this.shape, this.rp);
        } else if (this.itemStack != null) {
            renderer.drawItemStack(this.itemStack);
        }
    }

    @Override
    public String getPropertyString() {
        return (this.itemStack != null ? this.itemStack : "texture : " + this.texture + ", " + " icon : " + (Object)((Object)this.icon)) + super.getPropertyString();
    }
}

