/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IGuiText;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.GuiShape;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.element.XResizableGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.renderer.font.FontRenderOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;
import net.malisis.core.util.MouseButton;
import org.apache.commons.lang3.StringUtils;

public class UISlider
extends UIComponent<UISlider>
implements IGuiText<UISlider> {
    public static int SLIDER_WIDTH = 8;
    protected GuiIconProvider sliderIcon;
    protected MalisisFont font = MalisisFont.minecraftFont;
    protected FontRenderOptions fro = new FontRenderOptions();
    protected FontRenderOptions hoveredFro = new FontRenderOptions();
    private String text;
    private float minValue;
    private float maxValue;
    private float value;
    private float offset;
    private GuiShape sliderShape;

    public UISlider(MalisisGui gui, int width, float min, float max, String text) {
        super(gui);
        this.text = text;
        this.setSize(width, 20);
        this.minValue = min;
        this.maxValue = max;
        this.fro.color = 0xFFFFFF;
        this.fro.shadow = true;
        this.hoveredFro.color = 0xFFFFA0;
        this.hoveredFro.shadow = true;
        this.shape = new XResizableGuiShape();
        this.sliderShape = new SimpleGuiShape();
        this.sliderShape.setSize(8, 20);
        this.sliderShape.storeState();
        this.iconProvider = new GuiIconProvider(gui.getGuiTexture().getXResizableIcon(0, 0, 200, 20, 5));
        this.sliderIcon = new GuiIconProvider(gui.getGuiTexture().getIcon(227, 46, 8, 20));
    }

    public UISlider(MalisisGui gui, int width, float min, float max) {
        this(gui, width, min, max, null);
    }

    @Override
    public MalisisFont getFont() {
        return this.font;
    }

    @Override
    public UISlider setFont(MalisisFont font) {
        this.font = font;
        return this;
    }

    @Override
    public FontRenderOptions getFontRenderOptions() {
        return this.fro;
    }

    @Override
    public UISlider setFontRenderOptions(FontRenderOptions fro) {
        this.fro = fro;
        return this;
    }

    @Override
    public boolean onClick(int x, int y) {
        this.slideTo(x);
        return true;
    }

    @Override
    public boolean onScrollWheel(int x, int y, int delta) {
        this.slideBy(delta);
        return true;
    }

    @Override
    public boolean onDrag(int lastX, int lastY, int x, int y, MouseButton button) {
        this.slideTo(x);
        return true;
    }

    public void slideTo(int x) {
        int l = this.width - SLIDER_WIDTH;
        int pos = this.relativeX(x);
        pos = Math.max(0, Math.min(pos - SLIDER_WIDTH / 2, l));
        this.slideTo((float)pos / (float)l);
    }

    public void slideTo(float offset) {
        if (this.isDisabled()) {
            return;
        }
        if (offset < 0.0f) {
            offset = 0.0f;
        }
        if (offset > 1.0f) {
            offset = 1.0f;
        }
        this.offset = offset;
        float oldValue = this.value;
        float newValue = this.minValue + (this.maxValue - this.minValue) * offset;
        if (this.fireEvent(new ComponentEvent.ValueChange<UISlider, Float>(this, Float.valueOf(oldValue), Float.valueOf(newValue)))) {
            this.value = newValue;
        }
    }

    public void slideBy(float amount) {
        this.slideTo(this.offset + (amount *= 0.05f));
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.zIndex = 0;
        int ox = (int)(this.offset * (float)(this.width - SLIDER_WIDTH));
        this.sliderShape.resetState();
        this.sliderShape.setPosition(ox, 0);
        this.rp.iconProvider.set(this.sliderIcon);
        renderer.drawShape(this.sliderShape, this.rp);
        renderer.next();
        if (!StringUtils.isEmpty((CharSequence)this.text)) {
            String str = String.format(this.text, Float.valueOf(this.value));
            int x = (int)(((float)this.width - this.font.getStringWidth(str, this.fro)) / 2.0f);
            int y = 6;
            renderer.drawText(this.font, str, x, y, 0.0f, this.isHovered() ? this.hoveredFro : this.fro);
        }
    }
}

