/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory;

import java.util.HashMap;
import java.util.Map;
import net.malisis.core.inventory.InventoryState;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.util.ItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class MalisisSlot {
    private MalisisInventory inventory;
    private ItemStack itemStack;
    private Map<EntityPlayer, ItemStack> cachedItemStacks = new HashMap<EntityPlayer, ItemStack>();
    private ItemStack draggedItemStack;
    private Map<EntityPlayer, ItemStack> cachedDraggedItemStacks = new HashMap<EntityPlayer, ItemStack>();
    public int slotNumber;
    protected InventoryState state = new InventoryState();

    public MalisisSlot(MalisisInventory inventory, ItemStack itemStack, int index) {
        this.inventory = inventory;
        this.slotNumber = index;
        this.itemStack = itemStack;
    }

    public MalisisSlot(MalisisInventory inventory, int index) {
        this(inventory, null, index);
    }

    public MalisisSlot(int index) {
        this(null, null, index);
    }

    public void register(Object object) {
        if (this.inventory != null) {
            this.inventory.register(object);
        }
    }

    public void setInventory(MalisisInventory inventory) {
        this.inventory = inventory;
    }

    public MalisisInventory getInventory() {
        return this.inventory;
    }

    public int getInventoryId() {
        return this.inventory.getInventoryId();
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setDraggedItemStack(ItemStack itemStack) {
        this.draggedItemStack = itemStack;
    }

    public ItemStack getDraggedItemStack() {
        return this.draggedItemStack;
    }

    public void setOutputSlot() {
        this.state.unset(InventoryState.PLAYER_INSERT | InventoryState.AUTO_INSERT);
    }

    public boolean isOutputSlot() {
        return !this.state.is(InventoryState.PLAYER_INSERT) && !this.state.is(InventoryState.AUTO_INSERT);
    }

    public boolean isState(int state) {
        return this.inventory.state.is(state) && this.state.is(state);
    }

    public boolean isItemValid(ItemStack itemStack) {
        if (this.inventory == null) {
            return true;
        }
        return this.inventory.itemValidForSlot(this, itemStack);
    }

    public boolean isFull() {
        return this.itemStack != null && this.itemStack.stackSize == Math.min(this.itemStack.getMaxStackSize(), this.getSlotStackLimit());
    }

    public boolean isEmpty() {
        return this.itemStack == null || this.itemStack.stackSize == 0;
    }

    public void onSlotChanged() {
        this.inventory.onSlotChanged(this);
    }

    public void onPickupFromSlot(EntityPlayer player, ItemStack itemStack) {
        this.onSlotChanged();
    }

    public int setItemStackSize(int stackSize) {
        if (this.itemStack == null) {
            return 0;
        }
        if (stackSize <= 0) {
            stackSize = 0;
        }
        int start = this.itemStack.stackSize;
        this.itemStack.stackSize = Math.min(stackSize, Math.min(this.itemStack.getMaxStackSize(), this.getSlotStackLimit()));
        return this.itemStack.stackSize - start;
    }

    public int addItemStackSize(int stackSize) {
        if (this.itemStack == null) {
            return 0;
        }
        return this.setItemStackSize(this.itemStack.stackSize + stackSize);
    }

    public ItemStack extract(int amount) {
        ItemUtils.ItemStackSplitter iss = new ItemUtils.ItemStackSplitter(this.getItemStack());
        iss.split(amount);
        this.setItemStack(iss.source);
        this.onSlotChanged();
        return iss.split;
    }

    public ItemStack insert(ItemStack insert) {
        return this.insert(insert, insert != null ? insert.stackSize : 0, false);
    }

    public ItemStack insert(ItemStack insert, int amount) {
        return this.insert(insert, amount, false);
    }

    public ItemStack insert(ItemStack insert, int amount, boolean force) {
        if (insert == null) {
            return null;
        }
        if (!this.isItemValid(insert)) {
            return insert;
        }
        ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(insert, this.itemStack);
        if (!ism.canMerge() || this.isFull()) {
            if (!force) {
                return insert;
            }
            ItemStack slotStack = this.extract(-1);
            ItemStack insertStack = insert.copy();
            if (this.insert(insertStack, amount, false) != null) {
                this.setItemStack(slotStack);
                return insert;
            }
            return slotStack;
        }
        ism.merge(amount, this.getSlotStackLimit());
        this.setItemStack(ism.into);
        this.onSlotChanged();
        return ism.merge;
    }

    public int getSlotStackLimit() {
        if (this.inventory == null) {
            return 64;
        }
        return this.inventory.getInventoryStackLimit();
    }

    public boolean hasChanged(EntityPlayer player) {
        ItemStack cached = this.cachedItemStacks.get(player);
        ItemStack cachedDragged = this.cachedDraggedItemStacks.get(player);
        return !ItemStack.areItemStacksEqual((ItemStack)this.itemStack, (ItemStack)cached) || !ItemStack.areItemStacksEqual((ItemStack)this.draggedItemStack, (ItemStack)cachedDragged);
    }

    public void updateCache(EntityPlayer player) {
        this.cachedItemStacks.put(player, this.itemStack != null ? this.itemStack.copy() : null);
        this.cachedDraggedItemStacks.put(player, this.draggedItemStack != null ? this.draggedItemStack.copy() : null);
    }

    public void clearCache(EntityPlayer player) {
        this.cachedItemStacks.remove(player);
        this.cachedDraggedItemStacks.remove(player);
    }

    public String toString() {
        return this.slotNumber + (this.inventory != null ? "/" + this.inventory.getSizeInventory() : "") + " > " + this.itemStack;
    }
}

