/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.item;

import com.google.common.collect.Lists;
import java.util.List;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.IMergedBlock;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.block.MalisisBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MalisisItemBlock
extends ItemBlock
implements IRegisterable,
IComponentProvider {
    protected String name;
    protected final List<IComponent> components = Lists.newArrayList();

    public MalisisItemBlock(Block block) {
        super(block);
    }

    public MalisisItemBlock setName(String name) {
        this.name = name;
        this.setUnlocalizedName(name);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addComponent(IComponent component) {
        this.components.add(component);
    }

    @Override
    public List<IComponent> getComponents() {
        return this.components;
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        if (this.block instanceof MalisisBlock) {
            IBlockState state = ((MalisisBlock)this.block).getStateFromItemStack(itemStack);
            return ((MalisisBlock)this.block).getUnlocalizedName(state);
        }
        return super.getUnlocalizedName(itemStack);
    }

    public int getMetadata(int damage) {
        return damage;
    }

    public EnumActionResult onItemUse(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (itemStack.stackSize == 0) {
            return EnumActionResult.FAIL;
        }
        if (!player.canPlayerEdit(pos.offset(side), side, itemStack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState placedState = this.checkMerge(itemStack, player, world, pos, side, hitX, hitY, hitZ, false);
        BlockPos p = pos;
        if (placedState == null) {
            p = pos.offset(side);
            float x = hitX - (float)side.getFrontOffsetX();
            float y = hitY - (float)side.getFrontOffsetY();
            float z = hitZ - (float)side.getFrontOffsetZ();
            placedState = this.checkMerge(itemStack, player, world, p, side, x, y, z, true);
        }
        if (placedState == null) {
            return super.onItemUse(itemStack, player, world, pos, hand, side, hitX, hitY, hitZ);
        }
        Block block = placedState.getBlock();
        if (world.checkNoEntityCollision(block.getCollisionBoundingBox(placedState, world, p)) && world.setBlockState(p, placedState, 3)) {
            SoundType soundType = block.getSoundType();
            world.playSound(player, pos, soundType.getPlaceSound(), SoundCategory.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            --itemStack.stackSize;
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean canPlaceBlockOnSide(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack itemStack) {
        IMergedBlock mergedBlock = this.getMerged(world.getBlockState(pos));
        if (mergedBlock != null && mergedBlock.canMerge(itemStack, player, world, pos, side)) {
            return true;
        }
        mergedBlock = this.getMerged(world.getBlockState(pos = pos.offset(side)));
        if (mergedBlock != null && mergedBlock.canMerge(itemStack, player, world, pos, side)) {
            return true;
        }
        return super.canPlaceBlockOnSide(world, pos, side, player, itemStack);
    }

    private IMergedBlock getMerged(IBlockState state) {
        IMergedBlock mergedBlock = IComponent.getComponent(IMergedBlock.class, state.getBlock());
        if (mergedBlock == null) {
            return null;
        }
        if (mergedBlock.mergeSelfOnly() && state.getBlock() != this.block) {
            return null;
        }
        return mergedBlock;
    }

    private IBlockState checkMerge(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, boolean offset) {
        IBlockState state = world.getBlockState(pos);
        IMergedBlock mergedBlock = this.getMerged(state);
        if (mergedBlock == null || !mergedBlock.canMerge(itemStack, player, world, pos, side)) {
            return null;
        }
        return mergedBlock.mergeBlock(world, pos, state, itemStack, player, side, hitX, hitY, hitZ);
    }
}

