/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.renderer.IRenderComponent;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.face.SouthFace;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.renderer.model.loader.TextureModelLoader;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.TransformBuilder;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class DefaultRenderer {
    public static MalisisRenderer<?> nullRender = new Null();
    public static Block block = new Block();
    public static Item item = new Item();

    public static class Item
    extends MalisisRenderer<TileEntity> {
        private Matrix4f firstPersonRightHand = new TransformBuilder().translate(0.0f, 0.2f, 0.13f).scale(0.68f).rotate(0.0f, -90.0f, 25.0f).get();
        private Matrix4f firstPersonLeftHand = new TransformBuilder().translate(0.0f, 0.2f, 0.13f).scale(0.68f).rotate(0.0f, 90.0f, -25.0f).get();
        private Matrix4f thirdPersonRightHand = new TransformBuilder().translate(0.0f, 0.3f, 0.02f).scale(0.85f).rotate(0.0f, -90.0f, 55.0f).get();
        private Matrix4f thirdPersonLeftHand = new TransformBuilder().translate(0.0f, 0.3f, 0.02f).scale(0.85f).rotate(0.0f, 90.0f, -55.0f).get();
        private Shape gui;
        private Map<Icon, MalisisModel> itemModels = new HashMap<Icon, MalisisModel>();

        @Override
        public void initialize() {
            this.gui = new Shape(new SouthFace());
        }

        @Override
        public boolean isGui3d() {
            return false;
        }

        @Override
        public Matrix4f getTransform(net.minecraft.item.Item item, ItemCameraTransforms.TransformType tranformType) {
            Matrix4f ground = new TransformBuilder().scale(0.5f).get();
            switch (tranformType) {
                case FIRST_PERSON_LEFT_HAND: {
                    return this.firstPersonLeftHand;
                }
                case FIRST_PERSON_RIGHT_HAND: {
                    return this.firstPersonRightHand;
                }
                case THIRD_PERSON_LEFT_HAND: {
                    return this.thirdPersonLeftHand;
                }
                case THIRD_PERSON_RIGHT_HAND: {
                    return this.thirdPersonRightHand;
                }
                case GROUND: {
                    return ground;
                }
            }
            return null;
        }

        @Override
        public void render() {
            RenderParameters rp = new RenderParameters();
            rp.applyTexture.set(false);
            if (this.tranformType == ItemCameraTransforms.TransformType.GUI) {
                this.drawShape(this.gui);
            } else {
                this.drawShape(this.getModelShape(), rp);
            }
        }

        protected Shape getModelShape() {
            Icon icon = this.getIcon(null, new RenderParameters());
            MalisisModel model = this.itemModels.get((Object)icon);
            if (model == null) {
                model = new MalisisModel(new TextureModelLoader(icon));
                this.itemModels.put(icon, model);
            }
            return model.getShape("shape");
        }

        public void clearModels() {
            this.itemModels.clear();
        }
    }

    public static class Block
    extends MalisisRenderer<TileEntity> {
        private Matrix4f gui = new TransformBuilder().rotate(30.0f, 45.0f, 0.0f).scale(0.625f).get();
        private Matrix4f firstPersonLeftHand = new TransformBuilder().rotate(0.0f, 225.0f, 0.0f).scale(0.4f).get();
        private Matrix4f firstPersonRightHand = new TransformBuilder().rotate(0.0f, 45.0f, 0.0f).scale(0.4f).get();
        private Matrix4f thirdPerson = new TransformBuilder().translate(0.0f, 0.155f, 0.0f).rotateAfter(75.0f, 45.0f, 0.0f).scale(0.375f).get();
        private Matrix4f fixed = new TransformBuilder().scale(0.5f).get();
        private Matrix4f ground = new TransformBuilder().translate(0.0f, 0.3f, 0.0f).scale(0.25f).get();
        private Shape shape = new Cube();
        private RenderParameters rp = new RenderParameters();

        @Override
        public boolean isGui3d() {
            return true;
        }

        @Override
        public Matrix4f getTransform(net.minecraft.item.Item item, ItemCameraTransforms.TransformType tranformType) {
            switch (tranformType) {
                case GUI: {
                    return this.gui;
                }
                case FIRST_PERSON_LEFT_HAND: {
                    return this.firstPersonLeftHand;
                }
                case FIRST_PERSON_RIGHT_HAND: {
                    return this.firstPersonRightHand;
                }
                case THIRD_PERSON_LEFT_HAND: 
                case THIRD_PERSON_RIGHT_HAND: {
                    return this.thirdPerson;
                }
                case GROUND: {
                    return this.ground;
                }
                case FIXED: {
                    return this.fixed;
                }
            }
            return null;
        }

        @Override
        public void render() {
            AxisAlignedBB[] aabbs;
            IRenderComponent rc = IComponent.getComponent(IRenderComponent.class, this.block);
            if (rc != null) {
                rc.render(this.block, this);
                return;
            }
            if (this.block instanceof IBoundingBox) {
                aabbs = ((MalisisBlock)this.block).getRenderBoundingBox(this.world, this.pos, this.blockState);
                this.rp.useBlockBounds.set(false);
            } else {
                aabbs = AABBUtils.identities();
                this.rp.useBlockBounds.set(true);
            }
            for (AxisAlignedBB aabb : aabbs) {
                if (aabb == null) continue;
                this.shape.resetState().limit(aabb);
                this.rp.renderBounds.set(aabb);
                this.drawShape(this.shape, this.rp);
            }
        }
    }

    public static class Null
    extends MalisisRenderer<TileEntity> {
        @Override
        public void render() {
        }
    }
}

