/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.component;

import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.IRenderComponent;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.util.EnumFacingUtils;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class ShapeComponent
implements IRenderComponent {
    protected Shape shape;

    public ShapeComponent(Shape shape) {
        this.shape = shape;
    }

    @Override
    public void render(Block block, MalisisRenderer<TileEntity> renderer) {
        RenderParameters rp = new RenderParameters();
        rp.interpolateUV.set(false);
        this.shape.resetState();
        if (renderer.getRenderType() == RenderType.BLOCK) {
            EnumFacing direction = DirectionalComponent.getDirection(renderer.getBlockState());
            this.shape.rotate(90 * EnumFacingUtils.getRotationCount(direction), 0.0f, 1.0f, 0.0f);
            this.shape.applyMatrix();
            this.shape.deductParameters();
        }
        renderer.drawShape(this.shape, rp);
    }
}

