/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.malisis.core.renderer.icon.VanillaIcon;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import org.apache.commons.lang3.StringUtils;

public class Icon
extends TextureAtlasSprite {
    private static final Map<String, Icon> registeredIcons = Maps.newHashMap();
    public static Icon missing = new VanillaIcon.MissingIcon();
    public static int BLOCK_TEXTURE_WIDTH = -1;
    public static int BLOCK_TEXTURE_HEIGHT = -1;
    protected int sheetWidth;
    protected int sheetHeight;
    protected boolean flippedU = false;
    protected boolean flippedV = false;
    protected int rotation = 0;
    protected Set<Icon> dependants = new HashSet<Icon>();

    public Icon(String name, boolean register) {
        super(name);
        this.maxU = 1.0f;
        this.maxV = 1.0f;
        if (register && !StringUtils.isEmpty((CharSequence)name) && !registeredIcons.containsKey(name)) {
            registeredIcons.put(name, this);
        }
    }

    public Icon(String name) {
        this(name, true);
    }

    public Icon() {
        this("", false);
    }

    public Icon(Icon baseIcon) {
        this(baseIcon.getIconName(), false);
        baseIcon.addDependant(this);
    }

    public Icon(String name, float u, float v, float U, float V) {
        this(name, true);
        this.minU = u;
        this.minV = v;
        this.maxU = U;
        this.maxV = V;
    }

    public Icon(TextureAtlasSprite icon) {
        this(icon.getIconName(), false);
        this.copyFrom(icon);
    }

    public void addDependant(Icon icon) {
        this.dependants.add(icon);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setUVs(float u, float v, float U, float V) {
        this.minU = u;
        this.minV = v;
        this.maxU = U;
        this.maxV = V;
    }

    public float getMinU() {
        return this.flippedU ? this.maxU : this.minU;
    }

    public float getMaxU() {
        return this.flippedU ? this.minU : this.maxU;
    }

    public float getMinV() {
        return this.flippedV ? this.maxV : this.minV;
    }

    public float getMaxV() {
        return this.flippedV ? this.minV : this.maxV;
    }

    public Icon flip(boolean horizontal, boolean vertical) {
        this.flippedU = horizontal;
        this.flippedV = vertical;
        return this;
    }

    public boolean isFlippedU() {
        return this.flippedU;
    }

    public boolean isFlippedV() {
        return this.flippedV;
    }

    public boolean isRotated() {
        return this.rotation != 0;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    protected void initIcon(Icon baseIcon, int width, int height, int x, int y, boolean rotated) {
        this.copyFrom(baseIcon);
    }

    public Icon offset(int offsetX, int offsetY) {
        this.initSprite(this.sheetWidth, this.sheetHeight, this.getOriginX() + offsetX, this.getOriginY() + offsetY, this.isRotated());
        return this;
    }

    public Icon clip(int offsetX, int offsetY, int width, int height) {
        this.width = width;
        this.height = height;
        this.offset(offsetX, offsetY);
        return this;
    }

    public Icon clip(float offsetXFactor, float offsetYFactor, float widthFactor, float heightFactor) {
        int offsetX = Math.round((float)this.width * offsetXFactor);
        int offsetY = Math.round((float)this.height * offsetYFactor);
        this.width = Math.round((float)this.width * widthFactor);
        this.height = Math.round((float)this.height * heightFactor);
        this.offset(offsetX, offsetY);
        return this;
    }

    public void initSprite(int width, int height, int x, int y, boolean rotated) {
        if (width == 0 || height == 0) {
            width = BLOCK_TEXTURE_WIDTH;
            height = BLOCK_TEXTURE_HEIGHT;
        }
        this.sheetWidth = width;
        this.sheetHeight = height;
        super.initSprite(width, height, x, y, rotated);
        for (TextureAtlasSprite textureAtlasSprite : this.dependants) {
            if (textureAtlasSprite instanceof Icon) {
                ((Icon)textureAtlasSprite).initIcon(this, width, height, x, y, rotated);
                continue;
            }
            textureAtlasSprite.copyFrom((TextureAtlasSprite)this);
        }
    }

    public void copyFrom(TextureAtlasSprite base) {
        this.originX = base.getOriginX();
        this.originY = base.getOriginY();
        this.width = base.getIconWidth();
        this.height = base.getIconHeight();
        this.minU = base.getMinU();
        this.maxU = base.getMaxU();
        this.minV = base.getMinV();
        this.maxV = base.getMaxV();
        for (int i = 0; i < base.getFrameCount(); ++i) {
            this.framesTextureData.add(base.getFrameTextureData(i));
        }
        if (base instanceof Icon) {
            Icon mbase = (Icon)base;
            this.sheetWidth = mbase.sheetWidth;
            this.sheetHeight = mbase.sheetHeight;
            this.flippedU = mbase.flippedU;
            this.flippedV = mbase.flippedV;
        }
    }

    public Icon copy() {
        Icon icon = new Icon();
        icon.copyFrom(this);
        return icon;
    }

    public static void registerIcons(TextureMap map) {
        registeredIcons.forEach((arg_0, arg_1) -> ((TextureMap)map).setTextureEntry(arg_0, arg_1));
    }

    public static Icon from(String name) {
        if (name.indexOf("minecraft:") == 0) {
            return new VanillaIcon(name);
        }
        if (registeredIcons.get(name) != null) {
            return registeredIcons.get(name);
        }
        return new Icon(name);
    }

    public static Icon from(Block block) {
        return Icon.from(block.getDefaultState());
    }

    public static Icon from(IBlockState state) {
        return new VanillaIcon(state);
    }

    public static Icon from(Item item) {
        return new VanillaIcon(item);
    }

    public static Icon getRegistered(String name) {
        return registeredIcons.get(name);
    }
}

