/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon;

import java.io.IOException;
import java.util.List;
import net.malisis.core.renderer.icon.Icon;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;

public class VanillaIcon
extends Icon {
    protected Item item;
    protected IBlockState blockState;
    protected int metadata;
    protected String name;

    public VanillaIcon(String name) {
        this.name = name;
    }

    public VanillaIcon(Block block) {
        this.blockState = block.getDefaultState();
    }

    public VanillaIcon(IBlockState blockState) {
        this.blockState = blockState;
    }

    public VanillaIcon(Item item, int metadata) {
        this.item = item;
        this.metadata = metadata;
    }

    public VanillaIcon(Item item) {
        this(item, 0);
    }

    protected TextureAtlasSprite getIcon() {
        TextureAtlasSprite icon = null;
        if (this.name != null) {
            icon = Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(this.name);
        } else if (this.item != null) {
            icon = this.getItemIcon();
        } else if (this.blockState != null) {
            icon = this.getBlockIcon();
        }
        return icon == null ? missing : icon;
    }

    private TextureAtlasSprite getItemIcon() {
        if (Minecraft.getMinecraft().getRenderItem() == null) {
            return null;
        }
        return Minecraft.getMinecraft().getRenderItem().getItemModelMesher().getParticleIcon(this.item, this.metadata);
    }

    private TextureAtlasSprite getBlockIcon() {
        if (this.blockState == null) {
            return null;
        }
        return Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getTexture(this.blockState);
    }

    @Override
    public void initSprite(int inX, int inY, int originInX, int originInY, boolean rotatedIn) {
    }

    @Override
    public void copyFrom(TextureAtlasSprite atlasSprite) {
    }

    public int getOriginX() {
        return this.getIcon().getOriginX();
    }

    public int getOriginY() {
        return this.getIcon().getOriginY();
    }

    public int getIconWidth() {
        return this.getIcon().getIconWidth();
    }

    public int getIconHeight() {
        return this.getIcon().getIconHeight();
    }

    @Override
    public float getMinU() {
        return this.flippedU ? this.getIcon().getMaxU() : this.getIcon().getMinU();
    }

    @Override
    public float getMaxU() {
        return this.flippedU ? this.getIcon().getMinU() : this.getIcon().getMaxU();
    }

    public float getInterpolatedU(double u) {
        float f = this.getMaxU() - this.getMinU();
        return this.getMinU() + f * (float)u / 16.0f;
    }

    @Override
    public float getMinV() {
        return this.flippedV ? this.getIcon().getMaxV() : this.getIcon().getMinV();
    }

    @Override
    public float getMaxV() {
        return this.flippedV ? this.getIcon().getMinV() : this.getIcon().getMaxV();
    }

    public float getInterpolatedV(double v) {
        float f = this.getMaxV() - this.getMinV();
        return this.getMinV() + f * (float)v / 16.0f;
    }

    public String getIconName() {
        return this.getIcon().getIconName();
    }

    public void updateAnimation() {
    }

    public int[][] getFrameTextureData(int index) {
        return this.getIcon().getFrameTextureData(index);
    }

    public int getFrameCount() {
        return this.getIcon().getFrameCount();
    }

    public void setIconWidth(int newWidth) {
    }

    public void setIconHeight(int newHeight) {
    }

    public void loadSprite(PngSizeInfo sizeInfo, boolean animated) throws IOException {
    }

    public void generateMipmaps(int level) {
    }

    public void clearFramesTextureData() {
    }

    public boolean hasAnimationMetadata() {
        return this.getIcon().hasAnimationMetadata();
    }

    public void setFramesTextureData(List<int[][]> newFramesTextureData) {
    }

    public String toString() {
        return "VanillaIcon [" + this.getIcon() + "]";
    }

    public static class MissingIcon
    extends VanillaIcon {
        private TextureAtlasSprite missing;

        public MissingIcon() {
            super((Item)null);
        }

        @Override
        protected TextureAtlasSprite getIcon() {
            if (this.missing == null) {
                this.missing = Minecraft.getMinecraft().getTextureMapBlocks().getMissingSprite();
            }
            return this.missing;
        }
    }
}

