/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon.provider;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Map;
import java.util.Objects;
import net.malisis.core.block.component.WallComponent;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.ConnectedIconsProvider;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IconProviderBuilder {
    Type type = Type.DEFAULT;
    String prefix;
    String defaultName;
    Icon defaultIcon;
    Icon connectedIcon;
    Map<EnumFacing, Icon> sidesIcons = Maps.newHashMap();
    Table<IProperty<?>, Object, Icon> stateIcons = HashBasedTable.create();
    IProperty<?> currentProperty;
    Icon insideIcon;

    IconProviderBuilder(String prefix, Icon icon) {
        this.prefix = prefix;
        this.defaultIcon = icon;
    }

    IconProviderBuilder(String prefix, String name) {
        this.prefix = prefix;
        this.defaultIcon = this.icon(name);
    }

    private Icon icon(String name) {
        return Icon.from(this.prefix + name);
    }

    public IconProviderBuilder withSide(EnumFacing side, Icon icon) {
        this.type = Type.SIDES;
        this.sidesIcons.put(Objects.requireNonNull(side), icon);
        return this;
    }

    public IconProviderBuilder withSide(EnumFacing side, String iconName) {
        return this.withSide(side, this.icon(iconName));
    }

    public IconProviderBuilder connected() {
        return this.connectedWith(Icon.from(this.defaultIcon.getIconName() + "2"));
    }

    public IconProviderBuilder connectedWith(Icon icon) {
        this.type = Type.CONNECTED;
        this.connectedIcon = Objects.requireNonNull(icon);
        return this;
    }

    public IconProviderBuilder connectedWith(String iconName) {
        return this.connectedWith(this.icon(iconName));
    }

    public IconProviderBuilder forProperty(IProperty<?> property) {
        this.type = Type.STATE;
        this.currentProperty = property;
        return this;
    }

    public IconProviderBuilder withValue(Object value, Icon icon) {
        if (this.currentProperty == null) {
            throw new IllegalStateException("You must set the property first.");
        }
        if (!this.currentProperty.getAllowedValues().contains(value)) {
            throw new IllegalStateException("The property " + this.currentProperty + "(" + this.currentProperty.getClass().getSimpleName() + ") doesn't not contain value " + value);
        }
        this.stateIcons.put(this.currentProperty, value, (Object)icon);
        return this;
    }

    public IconProviderBuilder withValue(Object value, String iconName) {
        return this.withValue(value, this.icon(iconName));
    }

    public IconProviderBuilder wall(Icon insideIcon) {
        this.type = Type.WALL;
        this.insideIcon = insideIcon;
        return this;
    }

    public IconProviderBuilder wall(String insideIconName) {
        return this.wall(this.icon(insideIconName));
    }

    private IBlockIconProvider.IStatesIconProvider getStateIconProvider() {
        return state -> state.getProperties().keySet().stream().map(prop -> (Icon)((Object)((Object)((Object)this.stateIcons.get(prop, (Object)state.getValue(prop)))))).filter(Objects::nonNull).findFirst().orElse(this.defaultIcon);
    }

    private IBlockIconProvider getWallIconProvider() {
        return (state, side) -> {
            if (side == EnumFacing.SOUTH || side == EnumFacing.WEST && WallComponent.isCorner(state)) {
                return this.insideIcon;
            }
            return this.defaultIcon;
        };
    }

    public IIconProvider build() {
        switch (this.type) {
            case DEFAULT: {
                return () -> this.defaultIcon;
            }
            case SIDES: {
                return side -> (Icon)((Object)((Object)com.google.common.base.Objects.firstNonNull((Object)((Object)this.sidesIcons.get(side)), (Object)((Object)this.defaultIcon))));
            }
            case STATE: {
                return this.getStateIconProvider();
            }
            case WALL: {
                return this.getWallIconProvider();
            }
            case CONNECTED: {
                return new ConnectedIconsProvider(this);
            }
        }
        return null;
    }

    private static enum Type {
        DEFAULT,
        SIDES,
        CONNECTED,
        STATE,
        WALL;

    }
}

