/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon.provider;

import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SidesIconProvider
implements IBlockIconProvider.ISidesIconProvider {
    private Icon defaultIcon;
    private Icon[] sideIcons = new Icon[6];

    public SidesIconProvider(String defaultName, String[] sideNames) {
        this.setDefaultIcon(defaultName);
        this.setSideIcons(sideNames);
    }

    public SidesIconProvider(String defaultName) {
        this.setDefaultIcon(defaultName);
    }

    public SidesIconProvider(Icon defaultIcon, Icon[] sideIcons) {
        this.setDefaultIcon(defaultIcon);
        this.setSideIcons(sideIcons);
    }

    public SidesIconProvider(Icon defaultIcon) {
        this.setDefaultIcon(defaultIcon);
    }

    public void setDefaultIcon(String name) {
        this.defaultIcon = new Icon(name);
    }

    public void setDefaultIcon(Icon icon) {
        this.defaultIcon = icon;
    }

    public void setSideIcons(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)names[i])) continue;
            this.setSideIcon(EnumFacing.getFront((int)i), new Icon(names[i]));
        }
    }

    public void setSideIcons(Icon[] icons) {
        for (int i = 0; i < icons.length; ++i) {
            if (icons[i] == null) continue;
            this.setSideIcon(EnumFacing.getFront((int)i), icons[i]);
        }
    }

    public void setSideIcon(EnumFacing side, Icon icon) {
        if (this.defaultIcon == null) {
            this.defaultIcon = icon;
        }
        this.sideIcons[side.getIndex()] = icon;
    }

    public void setSideIcon(EnumFacing side, String name) {
        this.setSideIcon(side, new Icon(name));
    }

    @Override
    public Icon getIcon(EnumFacing side) {
        if (side == null || side.getIndex() > this.sideIcons.length) {
            return this.defaultIcon;
        }
        return (Icon)((Object)ObjectUtils.firstNonNull((Object[])new Icon[]{this.sideIcons[side.getIndex()], this.defaultIcon}));
    }

    @Override
    public Icon getIcon(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return this.getIcon(side);
    }

    @Override
    public Icon getIcon(ItemStack itemStack, EnumFacing side) {
        return this.getIcon(side);
    }

    @Override
    public Icon getIcon() {
        return this.defaultIcon;
    }
}

