/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.model.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.face.BottomFace;
import net.malisis.core.renderer.element.face.EastFace;
import net.malisis.core.renderer.element.face.NorthFace;
import net.malisis.core.renderer.element.face.SouthFace;
import net.malisis.core.renderer.element.face.TopFace;
import net.malisis.core.renderer.element.face.WestFace;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.model.IModelLoader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class TextureModelLoader
implements IModelLoader {
    private TextureAtlasSprite sprite;
    private int width;
    private int height;
    private int[] pixels;
    private Shape shape;

    public TextureModelLoader(ResourceLocation rl) {
    }

    public TextureModelLoader(TextureAtlasSprite sprite) {
        this.load(sprite);
    }

    private void load(TextureAtlasSprite sprite) {
        this.sprite = sprite;
        if (sprite.getFrameCount() == 0) {
            return;
        }
        this.pixels = sprite.getFrameTextureData(0)[0];
        this.width = sprite.getIconWidth();
        this.height = sprite.getIconHeight();
        List<Face> faces = this.readTexture();
        this.shape = new Shape(faces);
        this.shape.translate(-0.5f, -0.5f, 0.0f);
        this.shape.scale(1.0f / (float)this.width);
    }

    private List<Face> readTexture() {
        ArrayList<Face> faces = new ArrayList<Face>();
        SouthFace front = new SouthFace();
        front.scale(this.width, this.height, 1.0f);
        front.translate(0.0f, 0.0f, (float)this.width / 16.0f - 1.0f);
        front.setTexture(new Icon(this.sprite));
        NorthFace back = new NorthFace();
        back.scale(this.width, this.height, 1.0f);
        back.setTexture(new Icon(this.sprite), true, false, false);
        faces.add(front);
        faces.add(back);
        RenderParameters params = new RenderParameters();
        params.renderAllFaces.set(true);
        params.calculateAOColor.set(false);
        params.useEnvironmentBrightness.set(false);
        front.setParameters(params);
        back.setParameters(params);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.addPixelFaces(faces, x, y);
            }
        }
        return faces;
    }

    private void addPixelFaces(List<Face> faces, int x, int y) {
        EnumFacing[] facings;
        if (this.isPixelTransparent(x, y)) {
            return;
        }
        for (EnumFacing facing : facings = new EnumFacing[]{EnumFacing.WEST, EnumFacing.UP, EnumFacing.EAST, EnumFacing.DOWN}) {
            if (!this.isPixelTransparent(facing, x, y)) continue;
            Face face = this.getFace(facing);
            face.scale(1.0f, 1.0f, (float)this.width / 16.0f);
            face.translate(x, this.height - y - 1, 0.0f);
            this.applyTexture(face, x, y);
            RenderParameters params = face.getParameters();
            params.renderAllFaces.set(true);
            params.interpolateUV.set(false);
            faces.add(face);
        }
    }

    private Face getFace(EnumFacing facing) {
        switch (facing) {
            case WEST: {
                return new WestFace();
            }
            case UP: {
                return new TopFace();
            }
            case EAST: {
                return new EastFace();
            }
            case DOWN: {
                return new BottomFace();
            }
        }
        return null;
    }

    private void applyTexture(Face face, int x, int y) {
        float u = this.sprite.getInterpolatedU((double)((float)x / (float)this.width * 16.0f + 0.01f));
        float v = this.sprite.getInterpolatedV((double)((float)(++y) / (float)this.height * 16.0f - 0.01f));
        float U = this.sprite.getInterpolatedU((double)((float)x / (float)this.width * 16.0f + 0.01f));
        float V = this.sprite.getInterpolatedV((double)((float)y / (float)this.height * 16.0f - 0.01f));
        face.setTexture(new Icon("", u, v, U, V));
    }

    private int getPixel(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return 0;
        }
        int pos = x + y * this.width;
        return this.pixels[pos];
    }

    private boolean isPixelTransparent(int x, int y) {
        return (this.getPixel(x, y) >> 24 & 0xFF) == 0;
    }

    private boolean isPixelTransparent(EnumFacing facing, int x, int y) {
        return this.isPixelTransparent(x + facing.getFrontOffsetX(), y - facing.getFrontOffsetY());
    }

    @Override
    public Map<String, Shape> getShapes() {
        HashMap<String, Shape> map = new HashMap<String, Shape>();
        if (this.shape != null) {
            map.put("shape", this.shape);
        }
        return map;
    }
}

