/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class EntityUtils {
    private static EnumFacing[] facings = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP, EnumFacing.DOWN};
    private static Method getPlayerInstance;
    private static Field playersWatchingChunk;

    public static void spawnEjectedItem(World world, BlockPos pos, ItemStack itemStack) {
        if (itemStack == null || world.isRemote) {
            return;
        }
        float rx = world.rand.nextFloat() * 0.8f + 0.1f;
        float ry = world.rand.nextFloat() * 0.8f + 0.1f;
        float rz = world.rand.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, (double)((float)pos.getX() + rx), (double)((float)pos.getY() + ry), (double)((float)pos.getZ() + rz), itemStack);
        float factor = 0.05f;
        entityItem.motionX = world.rand.nextGaussian() * (double)factor;
        entityItem.motionY = world.rand.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.motionZ = world.rand.nextGaussian() * (double)factor;
        world.spawnEntityInWorld((Entity)entityItem);
    }

    public static EntityPlayerMP findPlayerFromUUID(UUID uuid) {
        return null;
    }

    public static EnumFacing getEntityFacing(Entity entity) {
        return EntityUtils.getEntityFacing(entity, false);
    }

    public static EnumFacing getEntityFacing(Entity entity, boolean sixWays) {
        return facings[EntityUtils.getEntityRotation(entity, sixWays)];
    }

    public static int getEntityRotation(Entity entity) {
        return EntityUtils.getEntityRotation(entity, false);
    }

    public static int getEntityRotation(Entity entity, boolean sixWays) {
        if (entity == null) {
            return 6;
        }
        float pitch = entity.rotationPitch;
        if (sixWays && pitch < -45.0f) {
            return 4;
        }
        if (sixWays && pitch > 45.0f) {
            return 5;
        }
        return MathHelper.floor_double((double)((double)(entity.rotationYaw * 4.0f / 360.0f) + 0.5)) + 2 & 3;
    }

    public static boolean isEquipped(EntityPlayer player, Item item, EnumHand hand) {
        return player != null && player.getHeldItem(hand) != null && player.getHeldItemMainhand().getItem() == item;
    }

    public static boolean isEquipped(EntityPlayer player, ItemStack itemStack, EnumHand hand) {
        return EntityUtils.isEquipped(player, itemStack != null ? itemStack.getItem() : null, hand);
    }

    public static List<EntityPlayerMP> getPlayersWatchingChunk(Chunk chunk) {
        return EntityUtils.getPlayersWatchingChunk((WorldServer)chunk.getWorld(), chunk.xPosition, chunk.zPosition);
    }

    public static List<EntityPlayerMP> getPlayersWatchingChunk(WorldServer world, int x, int z) {
        if (playersWatchingChunk == null) {
            return new ArrayList<EntityPlayerMP>();
        }
        try {
            Object playerInstance = getPlayerInstance.invoke((Object)world.getPlayerChunkMap(), x, z);
            if (playerInstance == null) {
                return new ArrayList<EntityPlayerMP>();
            }
            return (List)playersWatchingChunk.get(playerInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            MalisisCore.log.info("Failed to get players watching chunk :", (Throwable)e);
            return new ArrayList<EntityPlayerMP>();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer, IBlockState ... states) {
        if (ArrayUtils.isEmpty((Object[])states)) {
            states = new IBlockState[]{world.getBlockState(pos)};
        }
        int nb = 4;
        EntityDiggingFX.Factory factory = new EntityDiggingFX.Factory();
        for (int i = 0; i < nb; ++i) {
            for (int j = 0; j < nb; ++j) {
                for (int k = 0; k < nb; ++k) {
                    double fxX = (double)pos.getX() + ((double)i + 0.5) / (double)nb;
                    double fxY = (double)pos.getY() + ((double)j + 0.5) / (double)nb;
                    double fxZ = (double)pos.getZ() + ((double)k + 0.5) / (double)nb;
                    int id = Block.getStateId((IBlockState)states[world.rand.nextInt(states.length)]);
                    EntityDiggingFX fx = (EntityDiggingFX)factory.getEntityFX(0, world, fxX, fxY, fxZ, fxX - (double)pos.getX() - 0.5, fxY - (double)pos.getY() - 0.5, fxZ - (double)pos.getZ() - 0.5, new int[]{id});
                    effectRenderer.addEffect((EntityFX)fx);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addHitEffects(World world, RayTraceResult target, EffectRenderer effectRenderer, IBlockState ... states) {
        IBlockState baseState;
        BlockPos pos = target.getBlockPos();
        if (ArrayUtils.isEmpty((Object[])states)) {
            states = new IBlockState[]{world.getBlockState(pos)};
        }
        if ((baseState = world.getBlockState(pos)).getRenderType() != EnumBlockRenderType.INVISIBLE) {
            return;
        }
        double fxX = (double)pos.getX() + world.rand.nextDouble();
        double fxY = (double)pos.getY() + world.rand.nextDouble();
        double fxZ = (double)pos.getZ() + world.rand.nextDouble();
        AxisAlignedBB aabb = baseState.getBoundingBox((IBlockAccess)world, pos);
        switch (target.sideHit) {
            case DOWN: {
                fxY = (double)pos.getY() + aabb.minY - (double)0.1f;
                break;
            }
            case UP: {
                fxY = (double)pos.getY() + aabb.maxY + (double)0.1f;
                break;
            }
            case NORTH: {
                fxZ = (double)pos.getZ() + aabb.minZ - (double)0.1f;
                break;
            }
            case SOUTH: {
                fxZ = (double)pos.getZ() + aabb.maxY + (double)0.1f;
                break;
            }
            case EAST: {
                fxX = (double)pos.getX() + aabb.maxX + (double)0.1f;
                break;
            }
            case WEST: {
                fxX = (double)pos.getX() + aabb.minX + (double)0.1f;
                break;
            }
        }
        int id = Block.getStateId((IBlockState)states[world.rand.nextInt(states.length)]);
        EntityDiggingFX.Factory factory = new EntityDiggingFX.Factory();
        EntityDiggingFX fx = (EntityDiggingFX)factory.getEntityFX(0, world, fxX, fxY, fxZ, 0.0, 0.0, 0.0, new int[]{id});
        fx.multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f);
        effectRenderer.addEffect((EntityFX)fx);
    }

    static {
        try {
            getPlayerInstance = AsmUtils.changeMethodAccess(PlayerManager.class, "getEntry", "func_187301_b", "II");
            Class<?> clazz = Class.forName("net.minecraft.server.management.PlayerManager$PlayerInstance");
            playersWatchingChunk = AsmUtils.changeFieldAccess(clazz, "players", "field_187283_c");
        }
        catch (ClassNotFoundException e) {
            MalisisCore.log.error("Failed to get PlayerInstance class.", (Throwable)e);
        }
    }
}

