/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.util.Silenced;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemUtils {
    public static final int FULL_STACK = -1;
    public static final int HALF_STACK = -2;
    public static final Pattern pattern = Pattern.compile("((?<modid>.*?):)?(?<item>[^@]*)(@(?<damage>\\d+|[*])(x(?<size>\\d+))?)?");

    public static boolean areItemStacksStackable(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.isStackable() && stack1.getItem() == stack2.getItem() && (!stack2.getHasSubtypes() || stack2.getMetadata() == stack1.getMetadata()) && ItemStack.areItemStackTagsEqual((ItemStack)stack2, (ItemStack)stack1);
    }

    public static IBlockState getStateFromItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Block block = Block.getBlockFromItem((Item)itemStack.getItem());
        if (block == null) {
            return null;
        }
        if (block instanceof MalisisBlock) {
            return ((MalisisBlock)block).getStateFromItemStack(itemStack);
        }
        if (block instanceof BlockPistonBase) {
            return block.getDefaultState();
        }
        return block.getStateFromMeta(itemStack.getItem().getMetadata(itemStack.getMetadata()));
    }

    public static ItemStack getItemStackFromState(IBlockState state) {
        if (state == null) {
            return null;
        }
        Item item = Item.getItemFromBlock((Block)state.getBlock());
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1, state.getBlock().damageDropped(state));
    }

    public static ItemStack getItemStack(String str) {
        Item item;
        int size;
        Matcher matcher = pattern.matcher(str);
        if (!matcher.find()) {
            return null;
        }
        String itemString = matcher.group("item");
        if (itemString == null) {
            return null;
        }
        String modid = matcher.group("modid");
        if (modid == null) {
            modid = "minecraft";
        }
        int damage = 0;
        String strDamage = matcher.group("damage");
        if (strDamage != null) {
            damage = strDamage.equals("*") ? Short.MAX_VALUE : Silenced.get(() -> Integer.parseInt(matcher.group("damage")));
        }
        int n = size = matcher.group("size") == null ? 1 : Silenced.get(() -> Integer.parseInt(matcher.group("size")));
        if (size == 0) {
            size = 1;
        }
        if ((item = Item.getByNameOrId((String)(modid + ":" + itemString))) == null) {
            return null;
        }
        return new ItemStack(item, size, damage);
    }

    public static class ItemStackSplitter {
        public ItemStack source;
        public ItemStack split;
        public int amount;

        public ItemStackSplitter(ItemStack source) {
            this.source = source;
        }

        public ItemStack split(int amount) {
            if (this.source == null) {
                this.split = null;
                return null;
            }
            if (amount == -1) {
                amount = this.source.stackSize;
            } else if (amount == -2) {
                amount = (int)Math.ceil((float)this.source.stackSize / 2.0f);
            }
            this.amount = Math.min(amount, this.source.stackSize);
            this.split = this.source.splitStack(this.amount);
            if (this.source.stackSize <= 0) {
                this.source = null;
            }
            return this.split;
        }
    }

    public static class ItemStacksMerger {
        public ItemStack merge;
        public ItemStack into;
        public int nbMerged = -1;

        public ItemStacksMerger(ItemStack merge, ItemStack into) {
            this.merge = merge;
            this.into = into;
        }

        public boolean merge() {
            return this.merge(-1);
        }

        public boolean merge(int amount) {
            int max = 64;
            if (this.into != null) {
                max = this.into.getMaxStackSize();
            } else if (this.merge != null) {
                max = this.merge.getMaxStackSize();
            }
            return this.merge(amount, max);
        }

        public boolean merge(int amount, int intoMaxStackSize) {
            this.nbMerged = 0;
            if (!this.canMerge()) {
                return false;
            }
            if (this.merge == null) {
                return false;
            }
            if (amount == -1) {
                amount = this.merge.stackSize;
            }
            amount = Math.min(amount, this.merge.stackSize);
            if (this.into == null) {
                this.nbMerged = Math.min(amount, intoMaxStackSize);
                this.into = this.merge.copy();
                this.into.stackSize = this.nbMerged;
                this.merge.stackSize -= this.into.stackSize;
                if (this.merge.stackSize <= 0) {
                    this.merge = null;
                }
                return true;
            }
            this.nbMerged = Math.min(intoMaxStackSize, this.into.getMaxStackSize()) - this.into.stackSize;
            if (this.nbMerged == 0) {
                return false;
            }
            this.nbMerged = Math.min(this.nbMerged, amount);
            this.merge.stackSize -= this.nbMerged;
            if (this.merge.stackSize == 0) {
                this.merge = null;
            }
            this.into.stackSize += this.nbMerged;
            return true;
        }

        public boolean canMerge() {
            return this.merge == null || this.into == null || ItemUtils.areItemStacksStackable(this.merge, this.into);
        }
    }
}

