/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.lang.ref.WeakReference;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.EnumFacingUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MBlockState {
    private static BlockStateFunction toBlockState = new BlockStateFunction();
    private static BlockPredicate blockFilter = new BlockPredicate();
    protected BlockPos pos;
    protected Block block;
    protected IBlockState state;

    public MBlockState(BlockPos pos, IBlockState state) {
        this.pos = pos;
        this.block = state.getBlock();
        this.state = state;
    }

    public MBlockState(BlockPos pos, Block block) {
        this.pos = pos;
        this.block = block;
        this.state = block.getDefaultState();
    }

    public MBlockState(IBlockState state) {
        this.block = state.getBlock();
        this.state = state;
    }

    public MBlockState(Block block) {
        this.block = block;
        this.state = block.getDefaultState();
    }

    public MBlockState(IBlockAccess world, BlockPos pos) {
        this.pos = pos;
        this.state = world.getBlockState(pos);
        this.block = this.state.getBlock();
        this.state = this.block.getActualState(this.state, world, pos);
    }

    public MBlockState(IBlockAccess world, long coord) {
        this(world, BlockPos.fromLong((long)coord));
    }

    public MBlockState(BlockPos pos, MBlockState state) {
        this(pos, state.getBlockState());
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Block getBlock() {
        return this.block;
    }

    public IBlockState getBlockState() {
        return this.state;
    }

    public int getX() {
        return this.pos.getX();
    }

    public int getY() {
        return this.pos.getY();
    }

    public int getZ() {
        return this.pos.getZ();
    }

    public boolean isAir() {
        return this.getBlockState().getMaterial() == Material.AIR;
    }

    public MBlockState offset(BlockPos pos) {
        return new MBlockState(this.pos.add((Vec3i)pos), this);
    }

    public MBlockState rotate(int count) {
        IBlockState newState = this.state;
        for (IProperty prop : this.state.getProperties().keySet()) {
            if (!(prop instanceof PropertyDirection)) continue;
            EnumFacing facing = EnumFacingUtils.rotateFacing((EnumFacing)this.state.getValue(prop), 4 - count);
            newState = newState.withProperty((IProperty)((PropertyDirection)prop), (Comparable)facing);
        }
        return new MBlockState(BlockPosUtils.rotate(this.pos, count), newState);
    }

    public void placeBlock(World world) {
        world.setBlockState(this.pos, this.state);
    }

    public void placeBlock(World world, int flag) {
        world.setBlockState(this.pos, this.state, flag);
    }

    public void breakBlock(World world, int flag) {
        world.setBlockState(this.pos, Blocks.AIR.getDefaultState(), flag);
    }

    public boolean matchesWorld(IBlockAccess world) {
        MBlockState mstate = new MBlockState(world, this.pos);
        return mstate.getBlock() == this.getBlock() && this.getBlock().getMetaFromState(mstate.getBlockState()) == this.getBlock().getMetaFromState(this.getBlockState());
    }

    public static Iterable<MBlockState> getAllInBox(IBlockAccess world, BlockPos from, BlockPos to, Block block, boolean skipAir) {
        FluentIterable it = FluentIterable.from((Iterable)BlockPos.getAllInBox((BlockPos)from, (BlockPos)to)).transform((Function)toBlockState.set(world));
        if (block != null || skipAir) {
            it.filter((Predicate)blockFilter.set(block, skipAir));
        }
        return it;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MBlockState)) {
            return false;
        }
        MBlockState bs = (MBlockState)obj;
        return this.pos.equals((Object)bs.pos) && this.block == bs.block && this.state == bs.state;
    }

    public String toString() {
        return "[" + this.pos + "] " + (this.block != null ? this.block.getUnlocalizedName().substring(5) + " (" + this.state + ")" : "");
    }

    public static IBlockState fromNBT(NBTTagCompound nbt) {
        return MBlockState.fromNBT(nbt, "block", "metadata");
    }

    public static IBlockState fromNBT(NBTTagCompound nbt, String blockName, String metadataName) {
        if (nbt == null) {
            return null;
        }
        Block block = null;
        if (nbt.hasKey(blockName, 3)) {
            block = Block.getBlockById((int)nbt.getInteger(blockName));
        } else if (nbt.hasKey(blockName)) {
            block = Block.getBlockFromName((String)nbt.getString(blockName));
        }
        if (block == null) {
            return null;
        }
        int metadata = nbt.getInteger(metadataName);
        return block.getStateFromMeta(metadata);
    }

    public static NBTTagCompound toNBT(NBTTagCompound nbt, IBlockState state) {
        return MBlockState.toNBT(nbt, state, "block", "metadata");
    }

    public static NBTTagCompound toNBT(NBTTagCompound nbt, IBlockState state, String blockName, String metadataName) {
        if (state == null) {
            return nbt;
        }
        nbt.setString(blockName, ((ResourceLocation)Block.REGISTRY.getNameForObject((Object)state.getBlock())).toString());
        nbt.setInteger(metadataName, state.getBlock().getMetaFromState(state));
        return nbt;
    }

    public static class BlockPredicate
    implements Predicate<MBlockState> {
        public Block block;
        public boolean skipAir;

        public BlockPredicate set(Block block, boolean skipAir) {
            this.block = block;
            this.skipAir = skipAir;
            return this;
        }

        public boolean apply(MBlockState state) {
            if (this.block == null) {
                return state.getBlock() != Blocks.AIR;
            }
            return state.getBlock() == this.block;
        }
    }

    public static class BlockStateFunction
    implements Function<BlockPos, MBlockState> {
        public WeakReference<IBlockAccess> world;

        public BlockStateFunction set(IBlockAccess world) {
            this.world = new WeakReference<IBlockAccess>(world);
            return this;
        }

        public MBlockState apply(BlockPos pos) {
            return new MBlockState((IBlockAccess)this.world.get(), pos);
        }
    }
}

