/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import net.malisis.core.block.IBoundingBox;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.Silenced;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityUtils {
    @SideOnly(value=Side.CLIENT)
    private static TileEntity currentTileEntity;
    @SideOnly(value=Side.CLIENT)
    private static MalisisGui currenGui;

    public static <T> T getTileEntity(Class<T> clazz, IBlockAccess world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        TileEntity te = world.getTileEntity(pos);
        return (T)(te != null ? Silenced.get(() -> clazz.cast(te)) : null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void linkTileEntityToGui(TileEntity te, MalisisGui gui) {
        currentTileEntity = te;
        currenGui = gui;
        currenGui.updateGui();
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateGui(TileEntity te) {
        if (te != currentTileEntity) {
            return;
        }
        currenGui.updateGui();
    }

    public static AxisAlignedBB getRenderingBounds(TileEntity tileEntity) {
        Block block = tileEntity.getBlockType();
        BlockPos pos = tileEntity.getPos();
        World world = tileEntity.getWorld();
        AxisAlignedBB aabb = null;
        if (block instanceof IBoundingBox) {
            aabb = AABBUtils.combine(((IBoundingBox)block).getRenderBoundingBox((IBlockAccess)world, pos, world.getBlockState(pos)));
            aabb = AABBUtils.offset(pos, aabb);
        }
        return aabb != null ? aabb : AABBUtils.identity(pos);
    }

    public static void notifyUpdate(TileEntity te) {
        if (te.getWorld() == null) {
            return;
        }
        IBlockState state = te.getWorld().getBlockState(te.getPos());
        te.getWorld().notifyBlockUpdate(te.getPos(), state, state, 3);
    }
}

