/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.finiteliquid;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.finiteliquid.FiniteLiquidRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MalisisRendered(value=FiniteLiquidRenderer.class)
public abstract class FiniteLiquid
extends MalisisBlock {
    protected String name;
    public static final PropertyInteger AMOUNT = PropertyInteger.create((String)"amount", (int)0, (int)15);
    private static EnumFacing[] dirs = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};
    private int delay = 5;

    public FiniteLiquid(Material material) {
        super(material);
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Override
    public void register() {
        super.register();
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{AMOUNT});
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        if (!world.isRemote) {
            world.scheduleBlockUpdate(pos, (Block)this, this.delay, 0);
        }
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.setAmount(world, new MBlockState(pos, state), 15);
    }

    @Override
    public void onNeighborBlockChange(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (!world.isRemote) {
            world.scheduleBlockUpdate(pos, (Block)this, this.delay, 0);
        }
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.isRemote) {
            this.spreadLiquid(world, pos);
        }
    }

    public int getAmount(MBlockState state) {
        if (state.getBlock() == Blocks.AIR) {
            return 0;
        }
        if (state.getBlock() != this) {
            return -1;
        }
        return (Integer)state.getBlockState().getValue((IProperty)AMOUNT);
    }

    public void setAmount(World world, MBlockState state, int amount) {
        if (amount <= 0) {
            world.setBlockToAir(state.getPos());
        } else {
            if (this.getAmount(state) == amount) {
                return;
            }
            world.setBlockState(state.getPos(), this.getDefaultState().withProperty((IProperty)AMOUNT, (Comparable)Integer.valueOf(amount)));
            world.scheduleBlockUpdate(state.getPos(), (Block)this, this.delay, 0);
        }
    }

    public int addAmount(World world, MBlockState state, int amount) {
        int current = this.getAmount(state);
        if (current == -1 || current == 15) {
            return amount;
        }
        int newAmount = Math.min(15 - current, amount);
        this.setAmount(world, state, current + newAmount);
        return amount - newAmount;
    }

    private void spreadLiquid(World world, BlockPos pos) {
        MBlockState state = new MBlockState((IBlockAccess)world, pos);
        FloodFill ff = new FloodFill(this, world, state);
        ff.parse();
    }

    @Override
    public AxisAlignedBB[] getBoundingBoxes(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        int amount = world != null ? this.getAmount(new MBlockState(world, pos)) : 15;
        return new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)amount / 16.0, 1.0)};
    }

    @Override
    public boolean shouldSideBeRendered(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        Material material = world.getBlockState(pos).getMaterial();
        return material == this.blockMaterial ? false : (side == EnumFacing.UP ? true : super.shouldSideBeRendered(state, world, pos, side));
    }

    @Override
    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)AMOUNT, (Comparable)Integer.valueOf(meta));
    }

    @Override
    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)AMOUNT);
    }

    @Override
    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT;
    }

    public static class SpreadData {
        BlockPos pos;
        int amount;

        public SpreadData(BlockPos pos, int amount) {
            this.pos = pos;
            this.amount = amount;
        }
    }

    public static class FloodFill {
        FiniteLiquid fl;
        Set<BlockPos> parsed = new HashSet<BlockPos>();
        LinkedList<BlockPos> toParse = new LinkedList();
        World world;
        BlockPos origin;
        int amount = 0;

        public FloodFill(FiniteLiquid fl, World world, MBlockState state) {
            this.fl = fl;
            this.world = world;
            this.origin = state.getPos();
            this.amount = fl.getAmount(state);
            this.toParse.add(state.getPos());
        }

        public boolean shouldParse(BlockPos pos) {
            if (this.origin.distanceSq((Vec3i)pos) > 256.0) {
                return false;
            }
            if (this.toParse.contains(pos)) {
                return false;
            }
            MBlockState state = new MBlockState((IBlockAccess)this.world, pos);
            return state.getBlock() == this.fl || state.getBlock() == Blocks.AIR;
        }

        public void parse() {
            MBlockState state;
            while (this.toParse.size() > 0 && this.process(state = new MBlockState((IBlockAccess)this.world, this.toParse.removeFirst()))) {
                this.parse(state);
            }
            this.fl.setAmount(this.world, new MBlockState((IBlockAccess)this.world, this.origin), this.amount);
        }

        public boolean process(MBlockState state) {
            MBlockState down = new MBlockState((IBlockAccess)this.world, state.getPos().down());
            int da = this.fl.getAmount(down);
            if (da != -1 && da != 15) {
                int transfered = Math.min(this.amount, 4);
                transfered = Math.min(transfered, 15 - da);
                this.fl.setAmount(this.world, down, da + transfered);
                this.amount -= transfered;
                return this.amount > 0;
            }
            if (state.getPos().equals((Object)this.origin)) {
                return true;
            }
            int a = this.fl.getAmount(state);
            if (a < this.amount - 1) {
                this.fl.setAmount(this.world, state, a + 1);
                --this.amount;
            }
            return this.amount > 1;
        }

        public void parse(MBlockState state) {
            BlockPos pos = state.getPos();
            if (state.getBlock() == this.fl) {
                for (EnumFacing dir : dirs) {
                    BlockPos newPos = pos.offset(dir);
                    if (this.parsed.contains(newPos) || !this.shouldParse(newPos)) continue;
                    this.toParse.add(newPos);
                }
            }
            this.parsed.add(state.getPos());
        }
    }
}

