/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.finiteliquid;

import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.MergedVertex;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.finiteliquid.FiniteLiquid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class FiniteLiquidRenderer
extends MalisisRenderer<TileEntity> {
    private Shape shape;
    private RenderParameters rp;
    private FiniteLiquid block;

    @Override
    protected void initialize() {
        this.shape = new Cube();
        this.shape.enableMergedVertexes();
        this.rp = new RenderParameters();
        this.rp.calculateAOColor.set(false);
    }

    @Override
    public void render() {
        this.rp.calculateAOColor.set(false);
        this.block = (FiniteLiquid)((MalisisRenderer)this).block;
        this.shape.resetState();
        if (this.world == null) {
            this.drawShape(this.shape);
            return;
        }
        this.initialize();
        this.shape.resetState();
        this.rp.renderAllFaces.set(false);
        if (this.hasLiquidAbove(this.pos)) {
            this.drawShape(this.shape);
            return;
        }
        for (MergedVertex v : this.shape.getMergedVertexes(this.shape.getFace("top"))) {
            int[][] aom = v.getBase().getAoMatrix(EnumFacing.UP);
            boolean full = false;
            float height = (float)this.block.getAmount(new MBlockState(this.blockState)) / 16.0f;
            int count = 1;
            for (int i = 0; i < aom.length; ++i) {
                int oX = aom[i][0];
                int oY = aom[i][1] - 1;
                int oZ = aom[i][2];
                MBlockState state = new MBlockState(this.world, this.pos.add(oX, oY, oZ));
                if (state.getBlock() != this.block) continue;
                if (this.hasLiquidAbove(state.getPos())) {
                    full = true;
                    break;
                }
                height += (float)this.block.getAmount(state) / 16.0f;
                ++count;
            }
            v.setY(full ? 1.0 : (double)(height / (float)count));
        }
        this.drawShape(this.shape, this.rp);
    }

    private boolean hasLiquidAbove(BlockPos pos) {
        return this.world.getBlockState(pos.up()).getBlock() == this.block;
    }
}

