/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector.unmounters;

import java.io.IOException;
import net.samuelcampos.usbdrivedetector.process.CommandExecutor;
import net.samuelcampos.usbdrivedetector.process.OutputProcessor;
import net.samuelcampos.usbdrivedetector.unmounters.AbstractStorageDeviceUnmounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LinuxAndOSXStorageDeviceUnmounterBase
extends AbstractStorageDeviceUnmounter {
    private static final Logger log = LoggerFactory.getLogger(LinuxAndOSXStorageDeviceUnmounterBase.class);
    private final CommandExecutor commandExecutor = new CommandExecutor();

    protected void unmount(String unmoundCommand) {
        try (OutputProcessor commandOutputProcessor = this.commandExecutor.executeCommand(unmoundCommand);){
            Thread.sleep(1000L);
            commandOutputProcessor.processOutput(arg_0 -> ((Logger)log).trace(arg_0));
            log.debug("Device successfully unmount: {}", (Object)unmoundCommand);
        }
        catch (IOException | InterruptedException e) {
            log.error("Unable to unmount device: {}", (Object)unmoundCommand, (Object)e);
        }
    }
}

