/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.components.UIBean;
import com.opensymphony.xwork.util.OgnlValueStack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class FormButton
extends UIBean {
    static final String BUTTONTYPE_INPUT = "input";
    static final String BUTTONTYPE_BUTTON = "button";
    static final String BUTTONTYPE_IMAGE = "image";
    protected String action;
    protected String method;
    protected String align;
    protected String type;

    public FormButton(OgnlValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public void evaluateParams() {
        if (this.align == null) {
            this.align = "right";
        }
        String submitType = BUTTONTYPE_INPUT;
        if (this.type != null && (BUTTONTYPE_BUTTON.equalsIgnoreCase(this.type) || this.supportsImageType() && BUTTONTYPE_IMAGE.equalsIgnoreCase(this.type))) {
            submitType = this.type;
        }
        super.evaluateParams();
        this.addParameter("type", submitType);
        if (!BUTTONTYPE_INPUT.equals(submitType) && this.label == null) {
            this.addParameter("label", this.getParameters().get("nameValue"));
        }
        if (this.action != null || this.method != null) {
            String name;
            if (this.action != null) {
                name = "action:" + this.findString(this.action);
                if (this.method != null) {
                    name = name + "!" + this.findString(this.method);
                }
            } else {
                name = "method:" + this.findString(this.method);
            }
            this.addParameter("name", name);
        }
        this.addParameter("align", this.findString(this.align));
    }

    protected abstract boolean supportsImageType();

    public void setAction(String action) {
        this.action = action;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public void setType(String type) {
        this.type = type;
    }
}

