/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components.table;

import com.opensymphony.webwork.components.GenericUIBean;
import com.opensymphony.webwork.components.table.SortFilterModel;
import com.opensymphony.webwork.components.table.SortableTableModel;
import com.opensymphony.webwork.components.table.WebTableColumn;
import com.opensymphony.webwork.components.table.renderer.CellRenderer;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebTable
extends GenericUIBean {
    private static final Log LOG = LogFactory.getLog((Class)WebTable.class);
    public static final String TEMPLATE = "table";
    protected String sortOrder = "NONE";
    protected String modelName = null;
    protected TableModel model = null;
    protected WebTableColumn[] columns = null;
    protected boolean sortableAttr = false;
    protected int sortColumn = -1;
    protected int curRow = 0;

    public WebTable(OgnlValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    public boolean end(Writer writer, String body) {
        block12: {
            if (this.sortableAttr && this.model instanceof SortableTableModel) {
                LOG.debug((Object)("we are looking for " + this.getSortColumnLinkName()));
                String sortColumn = this.request.getParameter(this.getSortColumnLinkName());
                String sortOrder = this.request.getParameter(this.getSortOrderLinkName());
                try {
                    block13: {
                        if (sortColumn != null || sortOrder != null) {
                            block11: {
                                if (sortColumn != null) {
                                    try {
                                        this.sortColumn = Integer.parseInt(sortColumn);
                                    }
                                    catch (Exception ex) {
                                        if (!LOG.isDebugEnabled()) break block11;
                                        LOG.debug((Object)"coudn't convert column, take default");
                                    }
                                }
                            }
                            if (sortOrder != null) {
                                this.sortOrder = sortOrder;
                            }
                        } else {
                            LOG.debug((Object)"no sorting info in the request");
                        }
                        if (this.sortColumn < 0) break block12;
                        LOG.debug((Object)("we have the sortColumn " + Integer.toString(this.sortColumn)));
                        LOG.debug((Object)("we have the sortOrder " + this.sortOrder));
                        try {
                            ((SortableTableModel)this.model).sort(this.sortColumn, this.sortOrder);
                        }
                        catch (Exception ex) {
                            if (!LOG.isDebugEnabled()) break block13;
                            LOG.debug((Object)"couldn't sort the data");
                        }
                    }
                    LOG.debug((Object)"we just sorted the data");
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                    throw new RuntimeException("Error with WebTable: " + this.toString(e));
                }
            }
        }
        return super.end(writer, body);
    }

    public WebTableColumn getColumn(int index) {
        try {
            return this.columns[index];
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void evaluateExtraParams() {
        if (this.modelName != null) {
            this.modelName = this.findString(this.modelName);
            Object obj = this.stack.findValue(this.modelName);
            if (obj instanceof TableModel) {
                this.setModel((TableModel)obj);
            }
        }
        super.evaluateExtraParams();
    }

    protected int getNumberOfVisibleColumns() {
        int count = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i].isHidden()) continue;
            ++count;
        }
        return count;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public void setColumnDisplayName(int column, String displayName) {
        this.columns[column].setDisplayName(displayName);
    }

    public void getColumnDisplayName(int column) {
        this.columns[column].getDisplayName();
    }

    public void setColumnHidden(int column, boolean hide) {
        this.columns[column].setHidden(hide);
    }

    public boolean isColumnHidden(int column) {
        return this.columns[column].isHidden();
    }

    public void setColumnRenderer(int column, CellRenderer renderer) {
        this.columns[column].setRenderer(renderer);
    }

    public CellRenderer getColumnRenderer(int column) {
        return this.columns[column].getRenderer();
    }

    public WebTableColumn[] getColumns() {
        return this.columns;
    }

    public String[] getFormattedRow(int row) {
        ArrayList<String> data = new ArrayList<String>(this.getNumberOfVisibleColumns());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.columns[i].isVisible()) continue;
            data.add(this.columns[i].getRenderer().renderCell(this, this.model.getValueAt(row, i), row, i));
        }
        return data.toArray(new String[0]);
    }

    public void setModel(TableModel model) {
        this.model = model;
        this.columns = new WebTableColumn[this.model.getColumnCount()];
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = new WebTableColumn(this.model.getColumnName(i), i);
        }
        if (this.sortableAttr && !(this.model instanceof SortableTableModel)) {
            this.model = new SortFilterModel(this.model);
        }
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Object getRawData(int row, int column) {
        return this.model.getValueAt(row, column);
    }

    public Iterator getRawDataRowIterator() {
        return new WebTableRowIterator(this, 1);
    }

    public Object[] getRow(int row) {
        ArrayList<Object> data = new ArrayList<Object>(this.getNumberOfVisibleColumns());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.columns[i].isVisible()) continue;
            data.add(this.model.getValueAt(row, i));
        }
        return data.toArray(new Object[0]);
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public Iterator getRowIterator() {
        return new WebTableRowIterator(this);
    }

    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
    }

    public int getSortColumn() {
        if (this.model instanceof SortableTableModel) {
            return ((SortableTableModel)this.model).getSortedColumnNumber();
        }
        return -1;
    }

    public String getSortColumnLinkName() {
        return "WEBTABLE_" + this.modelName + "_SORT_COLUMN";
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder.equals("NONE") ? "NONE" : (sortOrder.equals("DESC") ? "DESC" : (sortOrder.equals("ASC") ? "ASC" : "NONE"));
    }

    public String getSortOrder() {
        if (this.model instanceof SortableTableModel && this.getSortColumn() >= 0) {
            return ((SortableTableModel)this.model).getSortedDirection(this.getSortColumn());
        }
        return "NONE";
    }

    public String getSortOrderLinkName() {
        return "WEBTABLE_" + this.modelName + "_SORT_ORDER";
    }

    public void setSortable(boolean sortable) {
        this.sortableAttr = sortable;
        if (this.sortableAttr && this.model != null && !(this.model instanceof SortableTableModel)) {
            this.model = new SortFilterModel(this.model);
        }
    }

    public boolean isSortable() {
        return this.sortableAttr;
    }

    public class WebTableRowIterator
    implements Iterator {
        public static final int FORMATTED_DATA = 0;
        public static final int RAW_DATA = 1;
        protected WebTable _table;
        protected int _curRow = 0;
        protected int _mode = 0;

        protected WebTableRowIterator(WebTable table) {
            this(table, 0);
        }

        protected WebTableRowIterator(WebTable table, int mode) {
            this._table = table;
            this._mode = mode;
        }

        public boolean hasNext() {
            if (this._table == null) {
                return false;
            }
            return this._table.getRowCount() > this._curRow;
        }

        public Object next() throws NoSuchElementException {
            if (this._table == null) {
                throw new NoSuchElementException("WebTable is null");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException("Beyond end of WebTable");
            }
            if (this._mode == 1) {
                return this._table.getRow(this._curRow++);
            }
            return this._table.getFormattedRow(this._curRow++);
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException("Remove not supported in WebTable");
        }
    }
}

