/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.interceptor;

import com.opensymphony.webwork.interceptor.BackgroundProcess;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.config.entities.ResultConfig;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExecuteAndWaitInterceptor
implements Interceptor {
    private static final Log LOG = LogFactory.getLog((Class)ExecuteAndWaitInterceptor.class);
    public static final String KEY = "__execWait";
    public static final String WAIT = "wait";
    protected int delay;
    protected int delaySleepInterval = 100;
    private int threadPriority = 5;

    public void init() {
    }

    protected BackgroundProcess getNewBackgroundProcess(String name, ActionInvocation actionInvocation, int threadPriority) {
        return new BackgroundProcess(name + "BackgroundThread", actionInvocation, threadPriority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        Map session;
        ActionProxy proxy = actionInvocation.getProxy();
        String name = proxy.getActionName();
        ActionContext context = actionInvocation.getInvocationContext();
        Map map = session = context.getSession();
        synchronized (map) {
            BackgroundProcess bp = (BackgroundProcess)session.get(KEY + name);
            if (bp == null) {
                bp = this.getNewBackgroundProcess(name, actionInvocation, this.threadPriority);
                session.put(KEY + name, bp);
                this.performInitialDelay(bp);
            }
            if (!bp.isDone()) {
                actionInvocation.getStack().push(bp.getAction());
                Map results = proxy.getConfig().getResults();
                if (!results.containsKey(WAIT)) {
                    LOG.warn((Object)"ExecuteAndWait interceptor has detected that no result named 'wait' is available. Defaulting to a plain built-in wait page. It is highly recommend you provide an action-specific or global result named 'wait'! This requires FreeMarker support and won't work if you don't have it installed");
                    ResultConfig rc = new ResultConfig(WAIT, "com.opensymphony.webwork.views.freemarker.FreemarkerResult", Collections.singletonMap("location", "com/opensymphony/webwork/interceptor/wait.ftl"));
                    results.put(WAIT, rc);
                }
                return WAIT;
            }
            session.remove(KEY + name);
            actionInvocation.getStack().push(bp.getAction());
            if (bp.getException() != null) {
                throw bp.getException();
            }
            return bp.getResult();
        }
    }

    public void destroy() {
    }

    protected void performInitialDelay(BackgroundProcess bp) throws InterruptedException {
        int step;
        if (this.delay <= 0 || this.delaySleepInterval <= 0) {
            return;
        }
        int steps = this.delay / this.delaySleepInterval;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Delaying for " + this.delay + " millis. (using " + steps + " steps)"));
        }
        for (step = 0; step < steps && !bp.isDone(); ++step) {
            Thread.sleep(this.delaySleepInterval);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sleeping ended after " + step + " steps and the background process is " + (bp.isDone() ? " done" : " not done")));
        }
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setDelaySleepInterval(int delaySleepInterval) {
        this.delaySleepInterval = delaySleepInterval;
    }
}

