/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class InvocationSessionStore {
    private static final String INVOCATION_MAP_KEY = "com.opensymphony.webwork.util.InvocationSessionStore.invocationMap";

    private InvocationSessionStore() {
    }

    public static ActionInvocation loadInvocation(String key, String token) {
        InvocationContext invocationContext = (InvocationContext)InvocationSessionStore.getInvocationMap().get(key);
        if (invocationContext == null || !invocationContext.token.equals(token)) {
            return null;
        }
        OgnlValueStack stack = invocationContext.invocation.getStack();
        ActionContext.getContext().setValueStack(stack);
        return invocationContext.invocation;
    }

    public static void storeInvocation(String key, String token, ActionInvocation invocation) {
        InvocationContext invocationContext = new InvocationContext(invocation, token);
        Map invocationMap = InvocationSessionStore.getInvocationMap();
        invocationMap.put(key, invocationContext);
        InvocationSessionStore.setInvocationMap(invocationMap);
    }

    static void setInvocationMap(Map invocationMap) {
        Map session = ActionContext.getContext().getSession();
        if (session == null) {
            throw new IllegalStateException("Unable to access the session.");
        }
        session.put(INVOCATION_MAP_KEY, invocationMap);
    }

    static Map getInvocationMap() {
        Map session = ActionContext.getContext().getSession();
        if (session == null) {
            throw new IllegalStateException("Unable to access the session.");
        }
        HashMap invocationMap = (HashMap)session.get(INVOCATION_MAP_KEY);
        if (invocationMap == null) {
            invocationMap = new HashMap();
            InvocationSessionStore.setInvocationMap(invocationMap);
        }
        return invocationMap;
    }

    private static class InvocationContext
    implements Serializable {
        ActionInvocation invocation;
        String token;

        public InvocationContext(ActionInvocation invocation, String token) {
            this.invocation = invocation;
            this.token = token;
        }
    }
}

