/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.jsp.iterator;

import com.opensymphony.webwork.util.MakeIterator;
import com.opensymphony.webwork.util.SortIteratorFilter;
import com.opensymphony.webwork.views.jsp.WebWorkBodyTagSupport;
import java.util.Comparator;
import javax.servlet.jsp.JspException;

public class SortIteratorTag
extends WebWorkBodyTagSupport {
    private static final long serialVersionUID = -7835719609764092235L;
    String comparatorAttr;
    String sourceAttr;
    SortIteratorFilter sortIteratorFilter = null;

    public void setComparator(String comparator) {
        this.comparatorAttr = comparator;
    }

    public void setSource(String source) {
        this.sourceAttr = source;
    }

    public int doStartTag() throws JspException {
        Object srcToSort = this.sourceAttr == null ? this.findValue("top") : this.findValue(this.sourceAttr);
        if (!MakeIterator.isIterable(srcToSort)) {
            throw new JspException("source [" + srcToSort + "] is not iteratable");
        }
        Object comparatorObj = this.findValue(this.comparatorAttr);
        if (!(comparatorObj instanceof Comparator)) {
            throw new JspException("comparator [" + comparatorObj + "] does not implements Comparator interface");
        }
        Comparator c = (Comparator)this.findValue(this.comparatorAttr);
        this.sortIteratorFilter = new SortIteratorFilter();
        this.sortIteratorFilter.setComparator(c);
        this.sortIteratorFilter.setSource(srcToSort);
        this.sortIteratorFilter.execute();
        this.getStack().push((Object)this.sortIteratorFilter);
        if (this.getId() != null && this.getId().length() > 0) {
            this.pageContext.setAttribute(this.getId(), (Object)this.sortIteratorFilter);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        int returnVal = super.doEndTag();
        this.getStack().pop();
        this.sortIteratorFilter = null;
        return returnVal;
    }
}

