/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.xslt;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.views.xslt.DOMAdapter;
import com.opensymphony.webwork.views.xslt.ServletURIResolver;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XSLTResult
implements Result {
    private static final Log log = LogFactory.getLog((Class)XSLTResult.class);
    public static final String DEFAULT_PARAM = "location";
    private static final Object LOCK = new Object();
    protected boolean noCache = false;
    protected Map templatesCache = new HashMap();
    protected String location;
    protected boolean parse;
    protected Pattern matchingPattern = null;
    protected Pattern excludingPattern = null;

    public XSLTResult() {
        this.noCache = Configuration.getString("webwork.xslt.nocache").trim().equalsIgnoreCase("true");
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setMatchingPattern(String matchingPattern) {
        this.matchingPattern = Pattern.compile(matchingPattern);
    }

    public void setExcludingPattern(String excludingPattern) {
        this.excludingPattern = Pattern.compile(excludingPattern);
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ActionInvocation invocation) throws Exception {
        long startTime = -1L;
        if (log.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
        }
        if (this.parse) {
            OgnlValueStack stack = ActionContext.getContext().getValueStack();
            this.location = TextParseUtil.translateVariables((String)this.location, (OgnlValueStack)stack);
        }
        if (this.location == null || this.location.trim().length() == 0) {
            String msg = "Location paramter is empty. Check the <param name=\"location\"> tag specified for this action.";
            log.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            HttpServletResponse response = ServletActionContext.getResponse();
            PrintWriter writer = response.getWriter();
            Templates templates = this.getTemplates(this.location);
            Transformer transformer = templates.newTransformer();
            String mimeType = templates.getOutputProperties().getProperty("media-type");
            if (mimeType == null) {
                log.debug((Object)"Not possible to determine MineType from media-type, using text/html then");
                mimeType = "text/html";
            }
            response.setContentType(mimeType);
            Source xmlSource = this.getTraxSourceForStack(invocation.getAction());
            PrintWriter out = response.getWriter();
            try {
                transformer.transform(xmlSource, new StreamResult(out));
            }
            finally {
                out.close();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Time: " + (System.currentTimeMillis() - startTime) + "ms"));
            }
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            log.error((Object)("Unable to render XSLT Template with location=[" + this.location + "]"), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Templates getTemplates(String path) throws TransformerException, IOException {
        String pathFromRequest = ServletActionContext.getRequest().getParameter("xslt.location");
        if (pathFromRequest != null) {
            path = pathFromRequest;
        }
        if (path == null) {
            throw new TransformerException("Stylesheet path is null");
        }
        Templates templates = (Templates)this.templatesCache.get(path);
        if (this.noCache || templates == null) {
            Object object = LOCK;
            synchronized (object) {
                URL resource = ServletActionContext.getServletContext().getResource(path);
                if (resource == null) {
                    throw new TransformerException("Stylesheet " + path + " not found in resources.");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Preparing new XSLT stylesheet: " + path));
                }
                TransformerFactory factory = TransformerFactory.newInstance();
                log.trace((Object)("Uri-Resolver is: " + factory.getURIResolver()));
                factory.setURIResolver(new ServletURIResolver(ServletActionContext.getServletContext()));
                log.trace((Object)("Uri-Resolver is: " + factory.getURIResolver()));
                templates = factory.newTemplates(new StreamSource(resource.openStream()));
                this.templatesCache.put(path, templates);
            }
        }
        return templates;
    }

    protected Source getTraxSourceForStack(Object action) throws IllegalAccessException, InstantiationException {
        DOMAdapter adapter = new DOMAdapter();
        adapter.setPattern(this.matchingPattern, this.excludingPattern);
        return new DOMSource(adapter.adapt(action));
    }
}

