/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.kaha.impl.async.ControlFile;
import org.apache.activemq.kaha.impl.async.DataFile;
import org.apache.activemq.kaha.impl.async.DataFileAccessor;
import org.apache.activemq.kaha.impl.async.DataFileAccessorPool;
import org.apache.activemq.kaha.impl.async.DataFileAppender;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.kaha.impl.async.NIODataFileAppender;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncDataManager {
    public static final int CONTROL_RECORD_MAX_LENGTH = 1024;
    public static final int ITEM_HEAD_RESERVED_SPACE = 21;
    public static final int ITEM_HEAD_SPACE = 29;
    public static final int ITEM_HEAD_OFFSET_TO_SOR = 26;
    public static final int ITEM_FOOT_SPACE = 3;
    public static final int ITEM_HEAD_FOOT_SPACE = 32;
    public static final byte[] ITEM_HEAD_SOR = new byte[]{83, 79, 82};
    public static final byte[] ITEM_HEAD_EOR = new byte[]{69, 79, 82};
    public static final byte DATA_ITEM_TYPE = 1;
    public static final byte REDO_ITEM_TYPE = 2;
    public static final String DEFAULT_DIRECTORY = "data";
    public static final String DEFAULT_ARCHIVE_DIRECTORY = "data-archive";
    public static final String DEFAULT_FILE_PREFIX = "data-";
    public static final int DEFAULT_MAX_FILE_LENGTH = 0x2000000;
    public static final int DEFAULT_CLEANUP_INTERVAL = 30000;
    public static final int PREFERED_DIFF = 524288;
    private static final Log LOG = LogFactory.getLog(AsyncDataManager.class);
    protected Scheduler scheduler;
    protected final Map<DataFileAppender.WriteKey, DataFileAppender.WriteCommand> inflightWrites = new ConcurrentHashMap<DataFileAppender.WriteKey, DataFileAppender.WriteCommand>();
    protected File directory = new File("data");
    protected File directoryArchive = new File("data-archive");
    protected String filePrefix = "data-";
    protected ControlFile controlFile;
    protected boolean started;
    protected boolean useNio = true;
    protected int maxFileLength = 0x2000000;
    protected int preferedFileLength = 33030144;
    protected DataFileAppender appender;
    protected DataFileAccessorPool accessorPool;
    protected Map<Integer, DataFile> fileMap = new HashMap<Integer, DataFile>();
    protected Map<File, DataFile> fileByFileMap = new LinkedHashMap<File, DataFile>();
    protected DataFile currentWriteFile;
    protected Location mark;
    protected final AtomicReference<Location> lastAppendLocation = new AtomicReference();
    protected Runnable cleanupTask;
    protected final AtomicLong storeSize;
    protected boolean archiveDataLogs;

    public AsyncDataManager(AtomicLong storeSize) {
        this.storeSize = storeSize;
    }

    public AsyncDataManager() {
        this(new AtomicLong());
    }

    public synchronized void start() throws IOException {
        Object l;
        if (this.started) {
            return;
        }
        this.started = true;
        this.preferedFileLength = Math.max(524288, this.getMaxFileLength() - 524288);
        this.lock();
        this.accessorPool = new DataFileAccessorPool(this);
        ByteSequence sequence = this.controlFile.load();
        if (sequence != null && sequence.getLength() > 0) {
            this.unmarshallState(sequence);
        }
        this.appender = this.useNio ? new NIODataFileAppender(this) : new DataFileAppender(this);
        File[] files = this.directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String n) {
                return dir.equals(AsyncDataManager.this.directory) && n.startsWith(AsyncDataManager.this.filePrefix);
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    File file = files[i];
                    String n = file.getName();
                    String numStr = n.substring(this.filePrefix.length(), n.length());
                    int num = Integer.parseInt(numStr);
                    DataFile dataFile = new DataFile(file, num, this.preferedFileLength);
                    this.fileMap.put(dataFile.getDataFileId(), dataFile);
                    this.storeSize.addAndGet(dataFile.getLength());
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            l = new ArrayList<DataFile>(this.fileMap.values());
            Collections.sort(l);
            this.currentWriteFile = null;
            Iterator i$ = l.iterator();
            while (i$.hasNext()) {
                DataFile df = (DataFile)i$.next();
                if (this.currentWriteFile != null) {
                    this.currentWriteFile.linkAfter(df);
                }
                this.currentWriteFile = df;
                this.fileByFileMap.put(df.getFile(), df);
            }
        }
        if (this.currentWriteFile != null) {
            l = this.lastAppendLocation.get();
            if (l != null && ((Location)l).getDataFileId() != this.currentWriteFile.getDataFileId().intValue()) {
                l = null;
            }
            try {
                l = this.recoveryCheck(this.currentWriteFile, (Location)l);
                this.lastAppendLocation.set((Location)l);
            }
            catch (IOException e) {
                LOG.warn("recovery check failed", e);
            }
        }
        this.storeState(false);
        this.cleanupTask = new Runnable(){

            public void run() {
                AsyncDataManager.this.cleanup();
            }
        };
        this.scheduler = new Scheduler("AsyncDataManager Scheduler");
        try {
            this.scheduler.start();
        }
        catch (Exception e) {
            IOException ioe = new IOException("scheduler start: " + e);
            ioe.initCause(e);
            throw ioe;
        }
        this.scheduler.executePeriodically(this.cleanupTask, 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws IOException {
        AsyncDataManager asyncDataManager = this;
        synchronized (asyncDataManager) {
            if (this.controlFile == null || this.controlFile.isDisposed()) {
                IOHelper.mkdirs(this.directory);
                this.controlFile = new ControlFile(new File(this.directory, this.filePrefix + "control"), 1024);
            }
            this.controlFile.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Location recoveryCheck(DataFile dataFile, Location location) throws IOException {
        if (location == null) {
            location = new Location();
            location.setDataFileId(dataFile.getDataFileId());
            location.setOffset(0);
        }
        DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
        try {
            reader.readLocationDetails(location);
            while (reader.readLocationDetailsAndValidate(location)) {
                location.setOffset(location.getOffset() + location.getSize());
            }
        }
        finally {
            this.accessorPool.closeDataFileAccessor(reader);
        }
        dataFile.setLength(location.getOffset());
        return location;
    }

    protected void unmarshallState(ByteSequence sequence) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(sequence.getData(), sequence.getOffset(), sequence.getLength());
        DataInputStream dis = new DataInputStream(bais);
        if (dis.readBoolean()) {
            this.mark = new Location();
            this.mark.readExternal(dis);
        } else {
            this.mark = null;
        }
        if (dis.readBoolean()) {
            Location l = new Location();
            l.readExternal(dis);
            this.lastAppendLocation.set(l);
        } else {
            this.lastAppendLocation.set(null);
        }
    }

    private synchronized ByteSequence marshallState() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        if (this.mark != null) {
            dos.writeBoolean(true);
            this.mark.writeExternal(dos);
        } else {
            dos.writeBoolean(false);
        }
        Location l = this.lastAppendLocation.get();
        if (l != null) {
            dos.writeBoolean(true);
            l.writeExternal(dos);
        } else {
            dos.writeBoolean(false);
        }
        byte[] bs = baos.toByteArray();
        return new ByteSequence(bs, 0, bs.length);
    }

    synchronized DataFile allocateLocation(Location location) throws IOException {
        if (this.currentWriteFile == null || this.currentWriteFile.getLength() + location.getSize() > this.maxFileLength) {
            int nextNum = this.currentWriteFile != null ? this.currentWriteFile.getDataFileId() + 1 : 1;
            String fileName = this.filePrefix + nextNum;
            File file = new File(this.directory, fileName);
            DataFile nextWriteFile = new DataFile(file, nextNum, this.preferedFileLength);
            nextWriteFile.closeRandomAccessFile(nextWriteFile.openRandomAccessFile(true));
            this.fileMap.put(nextWriteFile.getDataFileId(), nextWriteFile);
            this.fileByFileMap.put(file, nextWriteFile);
            if (this.currentWriteFile != null) {
                this.currentWriteFile.linkAfter(nextWriteFile);
                if (this.currentWriteFile.isUnused()) {
                    this.removeDataFile(this.currentWriteFile);
                }
            }
            this.currentWriteFile = nextWriteFile;
        }
        location.setOffset(this.currentWriteFile.getLength());
        location.setDataFileId(this.currentWriteFile.getDataFileId());
        int size = location.getSize();
        this.currentWriteFile.incrementLength(size);
        this.currentWriteFile.increment();
        this.storeSize.addAndGet(size);
        return this.currentWriteFile;
    }

    public synchronized void removeLocation(Location location) throws IOException {
        DataFile dataFile = this.getDataFile(location);
        dataFile.decrement();
    }

    synchronized DataFile getDataFile(Location item) throws IOException {
        Integer key = item.getDataFileId();
        DataFile dataFile = this.fileMap.get(key);
        if (dataFile == null) {
            LOG.error("Looking for key " + key + " but not found in fileMap: " + this.fileMap);
            throw new IOException("Could not locate data file " + this.filePrefix + item.getDataFileId());
        }
        return dataFile;
    }

    synchronized File getFile(Location item) throws IOException {
        Integer key = item.getDataFileId();
        DataFile dataFile = this.fileMap.get(key);
        if (dataFile == null) {
            LOG.error("Looking for key " + key + " but not found in fileMap: " + this.fileMap);
            throw new IOException("Could not locate data file " + this.filePrefix + item.getDataFileId());
        }
        return dataFile.getFile();
    }

    private DataFile getNextDataFile(DataFile dataFile) {
        return (DataFile)dataFile.getNext();
    }

    public synchronized void close() throws IOException {
        if (!this.started) {
            return;
        }
        this.scheduler.cancel(this.cleanupTask);
        try {
            this.scheduler.stop();
        }
        catch (Exception e) {
            IOException ioe = new IOException("scheduler stop: " + e);
            ioe.initCause(e);
            throw ioe;
        }
        this.accessorPool.close();
        this.storeState(false);
        this.appender.close();
        this.fileMap.clear();
        this.fileByFileMap.clear();
        this.controlFile.unlock();
        this.controlFile.dispose();
        this.started = false;
    }

    synchronized void cleanup() {
        if (this.accessorPool != null) {
            this.accessorPool.disposeUnused();
        }
    }

    public synchronized boolean delete() throws IOException {
        this.appender.close();
        this.accessorPool.close();
        boolean result = true;
        for (DataFile dataFile : this.fileMap.values()) {
            this.storeSize.addAndGet(-dataFile.getLength());
            result &= dataFile.delete();
        }
        this.fileMap.clear();
        this.fileByFileMap.clear();
        this.lastAppendLocation.set(null);
        this.mark = null;
        this.currentWriteFile = null;
        this.accessorPool = new DataFileAccessorPool(this);
        this.appender = this.useNio ? new NIODataFileAppender(this) : new DataFileAppender(this);
        return result;
    }

    public synchronized void addInterestInFile(int file) throws IOException {
        if (file >= 0) {
            Integer key = file;
            DataFile dataFile = this.fileMap.get(key);
            if (dataFile == null) {
                throw new IOException("That data file does not exist");
            }
            this.addInterestInFile(dataFile);
        }
    }

    synchronized void addInterestInFile(DataFile dataFile) {
        if (dataFile != null) {
            dataFile.increment();
        }
    }

    public synchronized void removeInterestInFile(int file) throws IOException {
        if (file >= 0) {
            Integer key = file;
            DataFile dataFile = this.fileMap.get(key);
            this.removeInterestInFile(dataFile);
        }
    }

    synchronized void removeInterestInFile(DataFile dataFile) throws IOException {
        if (dataFile != null && dataFile.decrement() <= 0) {
            this.removeDataFile(dataFile);
        }
    }

    public synchronized void consolidateDataFilesNotIn(Set<Integer> inUse, Set<Integer> inProgress) throws IOException {
        HashSet<Integer> unUsed = new HashSet<Integer>(this.fileMap.keySet());
        unUsed.removeAll(inUse);
        unUsed.removeAll(inProgress);
        ArrayList<DataFile> purgeList = new ArrayList<DataFile>();
        for (Integer key : unUsed) {
            DataFile dataFile = this.fileMap.get(key);
            purgeList.add(dataFile);
        }
        for (DataFile dataFile : purgeList) {
            if (dataFile.getDataFileId() == this.currentWriteFile.getDataFileId()) continue;
            this.forceRemoveDataFile(dataFile);
        }
    }

    public synchronized void consolidateDataFilesNotIn(Set<Integer> inUse, Integer lastFile) throws IOException {
        HashSet<Integer> unUsed = new HashSet<Integer>(this.fileMap.keySet());
        unUsed.removeAll(inUse);
        ArrayList<DataFile> purgeList = new ArrayList<DataFile>();
        for (Integer key : unUsed) {
            if (key >= lastFile) continue;
            DataFile dataFile = this.fileMap.get(key);
            purgeList.add(dataFile);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("lastFileId=" + lastFile + ", purgeList: (" + purgeList.size() + ") " + purgeList);
        }
        for (DataFile dataFile : purgeList) {
            this.forceRemoveDataFile(dataFile);
        }
    }

    public synchronized void consolidateDataFiles() throws IOException {
        ArrayList<DataFile> purgeList = new ArrayList<DataFile>();
        for (DataFile dataFile : this.fileMap.values()) {
            if (!dataFile.isUnused()) continue;
            purgeList.add(dataFile);
        }
        for (DataFile dataFile : purgeList) {
            this.removeDataFile(dataFile);
        }
    }

    private synchronized void removeDataFile(DataFile dataFile) throws IOException {
        if (dataFile == this.currentWriteFile || this.mark == null || dataFile.getDataFileId() >= this.mark.getDataFileId()) {
            LOG.debug("Won't remove DataFile" + dataFile);
            return;
        }
        this.forceRemoveDataFile(dataFile);
    }

    private synchronized void forceRemoveDataFile(DataFile dataFile) throws IOException {
        this.accessorPool.disposeDataFileAccessors(dataFile);
        this.fileByFileMap.remove(dataFile.getFile());
        this.fileMap.remove(dataFile.getDataFileId());
        this.storeSize.addAndGet(-dataFile.getLength());
        dataFile.unlink();
        if (this.archiveDataLogs) {
            dataFile.move(this.getDirectoryArchive());
            LOG.debug("moved data file " + dataFile + " to " + this.getDirectoryArchive());
        } else {
            boolean result = dataFile.delete();
            if (!result) {
                LOG.info("Failed to discard data file " + dataFile);
            }
        }
    }

    public int getMaxFileLength() {
        return this.maxFileLength;
    }

    public void setMaxFileLength(int maxFileLength) {
        this.maxFileLength = maxFileLength;
    }

    public String toString() {
        return "DataManager:(" + this.filePrefix + ")";
    }

    public synchronized Location getMark() throws IllegalStateException {
        return this.mark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Location getNextLocation(Location location) throws IOException, IllegalStateException {
        Location cur = null;
        do {
            if (cur == null) {
                if (location == null) {
                    DataFile head = (DataFile)this.currentWriteFile.getHeadNode();
                    cur = new Location();
                    cur.setDataFileId(head.getDataFileId());
                    cur.setOffset(0);
                } else if (location.getSize() == -1) {
                    cur = new Location(location);
                } else {
                    cur = new Location(location);
                    cur.setOffset(location.getOffset() + location.getSize());
                }
            } else {
                cur.setOffset(cur.getOffset() + cur.getSize());
            }
            DataFile dataFile = this.getDataFile(cur);
            if (dataFile.getLength() <= cur.getOffset()) {
                if ((dataFile = this.getNextDataFile(dataFile)) == null) {
                    return null;
                }
                cur.setDataFileId(dataFile.getDataFileId());
                cur.setOffset(0);
            }
            DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
            try {
                reader.readLocationDetails(cur);
            }
            finally {
                this.accessorPool.closeDataFileAccessor(reader);
            }
            if (cur.getType() != 0) continue;
            return null;
        } while (cur.getType() <= 0);
        return cur;
    }

    public synchronized Location getNextLocation(File file, Location lastLocation, boolean thisFileOnly) throws IllegalStateException, IOException {
        DataFile df = this.fileByFileMap.get(file);
        return this.getNextLocation(df, lastLocation, thisFileOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Location getNextLocation(DataFile dataFile, Location lastLocation, boolean thisFileOnly) throws IOException, IllegalStateException {
        Location cur = null;
        do {
            if (cur == null) {
                if (lastLocation == null) {
                    DataFile head = (DataFile)dataFile.getHeadNode();
                    cur = new Location();
                    cur.setDataFileId(head.getDataFileId());
                    cur.setOffset(0);
                } else {
                    cur = new Location(lastLocation);
                    cur.setOffset(cur.getOffset() + cur.getSize());
                }
            } else {
                cur.setOffset(cur.getOffset() + cur.getSize());
            }
            if (dataFile.getLength() <= cur.getOffset()) {
                if (thisFileOnly) {
                    return null;
                }
                if ((dataFile = this.getNextDataFile(dataFile)) == null) {
                    return null;
                }
                cur.setDataFileId(dataFile.getDataFileId());
                cur.setOffset(0);
            }
            DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
            try {
                reader.readLocationDetails(cur);
            }
            finally {
                this.accessorPool.closeDataFileAccessor(reader);
            }
            if (cur.getType() != 0) continue;
            return null;
        } while (cur.getType() <= 0);
        return cur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ByteSequence read(Location location) throws IOException, IllegalStateException {
        DataFile dataFile = this.getDataFile(location);
        DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
        ByteSequence rc = null;
        try {
            rc = reader.readRecord(location);
        }
        finally {
            this.accessorPool.closeDataFileAccessor(reader);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMark(Location location, boolean sync) throws IOException, IllegalStateException {
        AsyncDataManager asyncDataManager = this;
        synchronized (asyncDataManager) {
            this.mark = location;
        }
        this.storeState(sync);
    }

    protected synchronized void storeState(boolean sync) throws IOException {
        ByteSequence state = this.marshallState();
        this.appender.storeItem(state, (byte)-1, sync);
        this.controlFile.store(state, sync);
    }

    public synchronized Location write(ByteSequence data, boolean sync) throws IOException, IllegalStateException {
        Location loc = this.appender.storeItem(data, (byte)1, sync);
        return loc;
    }

    public synchronized Location write(ByteSequence data, Runnable onComplete) throws IOException, IllegalStateException {
        Location loc = this.appender.storeItem(data, (byte)1, onComplete);
        return loc;
    }

    public synchronized Location write(ByteSequence data, byte type, boolean sync) throws IOException, IllegalStateException {
        return this.appender.storeItem(data, type, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Location location, ByteSequence data, boolean sync) throws IOException {
        DataFile dataFile = this.getDataFile(location);
        DataFileAccessor updater = this.accessorPool.openDataFileAccessor(dataFile);
        try {
            updater.updateRecord(location, data, sync);
        }
        finally {
            this.accessorPool.closeDataFileAccessor(updater);
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = IOHelper.toFileSystemSafeName(filePrefix);
    }

    public Map<DataFileAppender.WriteKey, DataFileAppender.WriteCommand> getInflightWrites() {
        return this.inflightWrites;
    }

    public Location getLastAppendLocation() {
        return this.lastAppendLocation.get();
    }

    public void setLastAppendLocation(Location lastSyncedLocation) {
        this.lastAppendLocation.set(lastSyncedLocation);
    }

    public boolean isUseNio() {
        return this.useNio;
    }

    public void setUseNio(boolean useNio) {
        this.useNio = useNio;
    }

    public File getDirectoryArchive() {
        return this.directoryArchive;
    }

    public void setDirectoryArchive(File directoryArchive) {
        this.directoryArchive = directoryArchive;
    }

    public boolean isArchiveDataLogs() {
        return this.archiveDataLogs;
    }

    public void setArchiveDataLogs(boolean archiveDataLogs) {
        this.archiveDataLogs = archiveDataLogs;
    }

    public synchronized Integer getCurrentDataFileId() {
        if (this.currentWriteFile == null) {
            return null;
        }
        return this.currentWriteFile.getDataFileId();
    }

    public Set<File> getFiles() {
        return this.fileByFileMap.keySet();
    }

    public synchronized long getDiskSize() {
        long rc = 0L;
        for (DataFile cur = (DataFile)this.currentWriteFile.getHeadNode(); cur != null; cur = (DataFile)cur.getNext()) {
            rc += (long)cur.getLength();
        }
        return rc;
    }

    public synchronized long getDiskSizeUntil(Location startPosition) {
        long rc = 0L;
        for (DataFile cur = (DataFile)this.currentWriteFile.getHeadNode(); cur != null; cur = (DataFile)cur.getNext()) {
            if (cur.getDataFileId() >= startPosition.getDataFileId()) {
                return rc + (long)startPosition.getOffset();
            }
            rc += (long)cur.getLength();
        }
        return rc;
    }
}

