/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.context.annotation.BeanMethod;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.DescriptiveResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class ConfigurationClass {
    private final AnnotationMetadata metadata;
    private final Resource resource;
    @Nullable
    private String beanName;
    private final Set<ConfigurationClass> importedBy = new LinkedHashSet<ConfigurationClass>(1);
    private final Set<BeanMethod> beanMethods = new LinkedHashSet<BeanMethod>();
    private final Map<String, Class<? extends BeanDefinitionReader>> importedResources = new LinkedHashMap<String, Class<? extends BeanDefinitionReader>>();
    private final Map<ImportBeanDefinitionRegistrar, AnnotationMetadata> importBeanDefinitionRegistrars = new LinkedHashMap<ImportBeanDefinitionRegistrar, AnnotationMetadata>();
    final Set<String> skippedBeanMethods = new HashSet<String>();

    ConfigurationClass(MetadataReader metadataReader, String beanName) {
        Assert.notNull((Object)beanName, "Bean name must not be null");
        this.metadata = metadataReader.getAnnotationMetadata();
        this.resource = metadataReader.getResource();
        this.beanName = beanName;
    }

    ConfigurationClass(MetadataReader metadataReader, ConfigurationClass importedBy) {
        this.metadata = metadataReader.getAnnotationMetadata();
        this.resource = metadataReader.getResource();
        this.importedBy.add(importedBy);
    }

    ConfigurationClass(Class<?> clazz, String beanName) {
        Assert.notNull((Object)beanName, "Bean name must not be null");
        this.metadata = AnnotationMetadata.introspect(clazz);
        this.resource = new DescriptiveResource(clazz.getName());
        this.beanName = beanName;
    }

    ConfigurationClass(Class<?> clazz, ConfigurationClass importedBy) {
        this.metadata = AnnotationMetadata.introspect(clazz);
        this.resource = new DescriptiveResource(clazz.getName());
        this.importedBy.add(importedBy);
    }

    ConfigurationClass(AnnotationMetadata metadata, String beanName) {
        Assert.notNull((Object)beanName, "Bean name must not be null");
        this.metadata = metadata;
        this.resource = new DescriptiveResource(metadata.getClassName());
        this.beanName = beanName;
    }

    AnnotationMetadata getMetadata() {
        return this.metadata;
    }

    Resource getResource() {
        return this.resource;
    }

    String getSimpleName() {
        return ClassUtils.getShortName(this.getMetadata().getClassName());
    }

    void setBeanName(@Nullable String beanName) {
        this.beanName = beanName;
    }

    @Nullable
    String getBeanName() {
        return this.beanName;
    }

    boolean isImported() {
        return !this.importedBy.isEmpty();
    }

    void mergeImportedBy(ConfigurationClass otherConfigClass) {
        this.importedBy.addAll(otherConfigClass.importedBy);
    }

    Set<ConfigurationClass> getImportedBy() {
        return this.importedBy;
    }

    void addBeanMethod(BeanMethod method) {
        this.beanMethods.add(method);
    }

    Set<BeanMethod> getBeanMethods() {
        return this.beanMethods;
    }

    boolean hasNonStaticBeanMethods() {
        for (BeanMethod beanMethod : this.beanMethods) {
            if (beanMethod.getMetadata().isStatic()) continue;
            return true;
        }
        return false;
    }

    void addImportedResource(String importedResource, Class<? extends BeanDefinitionReader> readerClass) {
        this.importedResources.put(importedResource, readerClass);
    }

    Map<String, Class<? extends BeanDefinitionReader>> getImportedResources() {
        return this.importedResources;
    }

    void addImportBeanDefinitionRegistrar(ImportBeanDefinitionRegistrar registrar, AnnotationMetadata importingClassMetadata) {
        this.importBeanDefinitionRegistrars.put(registrar, importingClassMetadata);
    }

    Map<ImportBeanDefinitionRegistrar, AnnotationMetadata> getImportBeanDefinitionRegistrars() {
        return this.importBeanDefinitionRegistrars;
    }

    void validate(ProblemReporter problemReporter) {
        Map<String, Object> attributes = this.metadata.getAnnotationAttributes(Configuration.class.getName());
        if (attributes != null && ((Boolean)attributes.get("proxyBeanMethods")).booleanValue()) {
            if (this.hasNonStaticBeanMethods() && this.metadata.isFinal()) {
                problemReporter.error(new FinalConfigurationProblem());
            }
            for (BeanMethod beanMethod : this.beanMethods) {
                beanMethod.validate(problemReporter);
            }
        }
        if (attributes != null && ((Boolean)attributes.get("enforceUniqueMethods")).booleanValue()) {
            LinkedHashMap<String, MethodMetadata> beanMethodsByName = new LinkedHashMap<String, MethodMetadata>();
            for (BeanMethod beanMethod : this.beanMethods) {
                MethodMetadata current = beanMethod.getMetadata();
                MethodMetadata existing = beanMethodsByName.put(current.getMethodName(), current);
                if (existing == null || !existing.getDeclaringClassName().equals(current.getDeclaringClassName())) continue;
                problemReporter.error(new BeanMethodOverloadingProblem(existing.getMethodName()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof ConfigurationClass)) return false;
        ConfigurationClass that = (ConfigurationClass)other;
        if (!this.getMetadata().getClassName().equals(that.getMetadata().getClassName())) return false;
        return true;
    }

    public int hashCode() {
        return this.getMetadata().getClassName().hashCode();
    }

    public String toString() {
        return "ConfigurationClass: beanName '" + this.beanName + "', " + String.valueOf(this.resource);
    }

    private class FinalConfigurationProblem
    extends Problem {
        FinalConfigurationProblem() {
            super(String.format("@Configuration class '%s' may not be final. Remove the final modifier to continue.", ConfigurationClass.this.getSimpleName()), new Location(ConfigurationClass.this.getResource(), ConfigurationClass.this.getMetadata()));
        }
    }

    private class BeanMethodOverloadingProblem
    extends Problem {
        BeanMethodOverloadingProblem(String methodName) {
            super(String.format("@Configuration class '%s' contains overloaded @Bean methods with name '%s'. Use unique method names for separate bean definitions (with individual conditions etc) or switch '@Configuration.enforceUniqueMethods' to 'false'.", ConfigurationClass.this.getSimpleName(), methodName), new Location(ConfigurationClass.this.getResource(), ConfigurationClass.this.getMetadata()));
        }
    }
}

