/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.reactive;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.transaction.ReactiveTransaction;
import org.springframework.transaction.ReactiveTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.reactive.TransactionCallback;
import org.springframework.transaction.reactive.TransactionContextManager;
import org.springframework.transaction.reactive.TransactionalOperator;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class TransactionalOperatorImpl
implements TransactionalOperator {
    private static final Log logger = LogFactory.getLog(TransactionalOperatorImpl.class);
    private final ReactiveTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition;

    TransactionalOperatorImpl(ReactiveTransactionManager transactionManager, TransactionDefinition transactionDefinition) {
        Assert.notNull((Object)transactionManager, "ReactiveTransactionManager must not be null");
        Assert.notNull((Object)transactionDefinition, "TransactionDefinition must not be null");
        this.transactionManager = transactionManager;
        this.transactionDefinition = transactionDefinition;
    }

    public ReactiveTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public <T> Flux<T> execute(TransactionCallback<T> action) throws TransactionException {
        return TransactionContextManager.currentContext().flatMapMany(context -> Flux.usingWhen(this.transactionManager.getReactiveTransaction(this.transactionDefinition), action::doInTransaction, this.transactionManager::commit, this::rollbackOnException, this.transactionManager::rollback).onErrorMap(this::unwrapIfResourceCleanupFailure)).contextWrite(TransactionContextManager.getOrCreateContext()).contextWrite(TransactionContextManager.getOrCreateContextHolder());
    }

    private Mono<Void> rollbackOnException(ReactiveTransaction status, Throwable ex) throws TransactionException {
        logger.debug((Object)"Initiating transaction rollback on application exception", ex);
        return this.transactionManager.rollback(status).onErrorMap(ex2 -> {
            logger.error((Object)"Application exception overridden by rollback exception", ex);
            if (ex2 instanceof TransactionSystemException) {
                TransactionSystemException tse = (TransactionSystemException)ex2;
                tse.initApplicationException(ex);
            } else {
                ex2.addSuppressed(ex);
            }
            return ex2;
        });
    }

    private Throwable unwrapIfResourceCleanupFailure(Throwable ex) {
        String msg;
        if (ex instanceof RuntimeException && ex.getCause() != null && (msg = ex.getMessage()) != null && msg.startsWith("Async resource cleanup failed")) {
            return ex.getCause();
        }
        return ex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!super.equals(other)) return false;
        if (!(other instanceof TransactionalOperatorImpl)) return true;
        TransactionalOperatorImpl toi = (TransactionalOperatorImpl)other;
        if (this.getTransactionManager() != toi.getTransactionManager()) return false;
        return true;
    }

    public int hashCode() {
        return this.getTransactionManager().hashCode();
    }
}

