/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(RestFilter.class);
    private static final String HTTP_HEADER_DESTINATION = "Destination";
    private static final String HTTP_METHOD_MOVE = "MOVE";
    private static final String HTTP_METHOD_PUT = "PUT";
    private static final String HTTP_METHOD_GET = "GET";
    private static final String HTTP_METHOD_DELETE = "DELETE";
    private String readPermissionRole;
    private String writePermissionRole;
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws UnavailableException {
        this.filterConfig = filterConfig;
        this.readPermissionRole = filterConfig.getInitParameter("read-permission-role");
        this.writePermissionRole = filterConfig.getInitParameter("write-permission-role");
    }

    private File locateFile(HttpServletRequest request) {
        return new File(this.filterConfig.getServletContext().getRealPath(request.getServletPath()), request.getPathInfo());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("request not HTTP, can not understand: " + request.toString());
            }
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getMethod().equals(HTTP_METHOD_MOVE)) {
            this.doMove(httpRequest, httpResponse);
        } else if (httpRequest.getMethod().equals(HTTP_METHOD_PUT)) {
            this.doPut(httpRequest, httpResponse);
        } else if (httpRequest.getMethod().equals(HTTP_METHOD_GET)) {
            if (this.checkGet(httpRequest, httpResponse)) {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
        } else if (httpRequest.getMethod().equals(HTTP_METHOD_DELETE)) {
            this.doDelete(httpRequest, httpResponse);
        } else {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    protected void doMove(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("RESTful file access: MOVE request for " + request.getRequestURI());
        }
        if (this.writePermissionRole != null && !request.isUserInRole(this.writePermissionRole)) {
            response.sendError(403);
            return;
        }
        File file = this.locateFile(request);
        String destination = request.getHeader(HTTP_HEADER_DESTINATION);
        if (destination == null) {
            response.sendError(400, "Destination header not found");
            return;
        }
        try {
            URL destinationUrl = new URL(destination);
            IOHelper.copyFile((File)file, (File)new File(destinationUrl.getFile()));
            IOHelper.deleteFile((File)file);
        }
        catch (IOException e) {
            response.sendError(500);
            return;
        }
        response.setStatus(204);
    }

    protected boolean checkGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("RESTful file access: GET request for " + request.getRequestURI());
        }
        if (this.readPermissionRole != null && !request.isUserInRole(this.readPermissionRole)) {
            response.sendError(403);
            return false;
        }
        return true;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean success;
        if (LOG.isDebugEnabled()) {
            LOG.debug("RESTful file access: PUT request for " + request.getRequestURI());
        }
        if (this.writePermissionRole != null && !request.isUserInRole(this.writePermissionRole)) {
            response.sendError(403);
            return;
        }
        File file = this.locateFile(request);
        if (file.exists() && !(success = file.delete())) {
            response.sendError(500);
            return;
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            IOHelper.copyInputStream((InputStream)request.getInputStream(), (OutputStream)out);
        }
        catch (IOException e) {
            LOG.warn("Exception occured", (Throwable)e);
            out.close();
            throw e;
        }
        response.setStatus(204);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("RESTful file access: DELETE request for " + request.getRequestURI());
        }
        if (this.writePermissionRole != null && !request.isUserInRole(this.writePermissionRole)) {
            response.sendError(403);
            return;
        }
        File file = this.locateFile(request);
        if (!file.exists()) {
            response.sendError(404);
            return;
        }
        boolean success = IOHelper.deleteFile((File)file);
        if (success) {
            response.setStatus(204);
        } else {
            response.sendError(500);
        }
    }

    public void destroy() {
    }
}

