/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Test;

public class DatabaseStoreConfigurationTest
extends ActiveMQTestBase {
    @Test
    public void databaseStoreConfigTest() throws Exception {
        Configuration configuration = this.createConfiguration("database-store-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        DatabaseStoreConfigurationTest.assertEquals((Object)StoreConfiguration.StoreType.DATABASE, (Object)server.getConfiguration().getStoreConfiguration().getStoreType());
    }

    protected Configuration createConfiguration(String fileName) throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(fileName);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        fc.setPagingDirectory(this.getTestDir() + "/" + fc.getPagingDirectory());
        fc.setLargeMessagesDirectory(this.getTestDir() + "/" + fc.getLargeMessagesDirectory());
        fc.setJournalDirectory(this.getTestDir() + "/" + fc.getJournalDirectory());
        fc.setBindingsDirectory(this.getTestDir() + "/" + fc.getBindingsDirectory());
        return fc;
    }
}

