/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.QueueConfig;
import org.junit.Assert;
import org.junit.Test;

public class QueueConfigTest {
    @Test
    public void addressMustBeDefaultedToName() {
        QueueConfig queueConfig = QueueConfig.builderWith((long)1L, (SimpleString)new SimpleString("queue_name")).build();
        Assert.assertEquals((Object)queueConfig.name(), (Object)queueConfig.address());
    }

    @Test(expected=IllegalStateException.class)
    public void cannotAllowNullAddress() {
        QueueConfig.builderWith((long)1L, (SimpleString)new SimpleString("queue_name"), null);
    }

    @Test(expected=IllegalStateException.class)
    public void cannotAllowNullNameWithoutAddress() {
        QueueConfig.builderWith((long)1L, null);
    }

    @Test(expected=IllegalStateException.class)
    public void cannotAllowNullNameWithAddress() {
        QueueConfig.builderWith((long)1L, null, (SimpleString)new SimpleString("queue_address"));
    }
}

