/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.files;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileStore;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileStoreMonitorTest
extends ActiveMQTestBase {
    private ScheduledExecutorService scheduledExecutorService;
    private ExecutorService executorService;

    @Before
    public void startScheduled() {
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(5);
        this.executorService = Executors.newSingleThreadExecutor();
    }

    @After
    public void stopScheduled() {
        this.scheduledExecutorService.shutdown();
        this.scheduledExecutorService = null;
        this.executorService.shutdown();
    }

    @Test
    public void testSimpleTick() throws Exception {
        File garbageFile = new File(this.getTestDirfile(), "garbage.bin");
        FileOutputStream garbage = new FileOutputStream(garbageFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(garbage);
        PrintStream out = new PrintStream(bufferedOutputStream);
        for (int i = 0; i < 100; ++i) {
            out.println("Garbage " + i);
        }
        bufferedOutputStream.close();
        final AtomicInteger over = new AtomicInteger(0);
        final AtomicInteger under = new AtomicInteger(0);
        final AtomicInteger tick = new AtomicInteger(0);
        FileStoreMonitor.Callback callback = new FileStoreMonitor.Callback(){

            public void tick(FileStore store, double usage) {
                tick.incrementAndGet();
                System.out.println("tick:: " + store + " usage::" + usage);
            }

            public void over(FileStore store, double usage) {
                over.incrementAndGet();
                System.out.println("over:: " + store + " usage::" + usage);
            }

            public void under(FileStore store, double usage) {
                under.incrementAndGet();
                System.out.println("under:: " + store + " usage::" + usage);
            }
        };
        final AtomicBoolean fakeReturn = new AtomicBoolean(false);
        FileStoreMonitor storeMonitor = new FileStoreMonitor(this.scheduledExecutorService, this.executorService, 100L, TimeUnit.MILLISECONDS, 0.999){

            protected double calculateUsage(FileStore store) throws IOException {
                if (fakeReturn.get()) {
                    return 1.0;
                }
                return super.calculateUsage(store);
            }
        };
        storeMonitor.addCallback(callback);
        storeMonitor.addStore(this.getTestDirfile());
        storeMonitor.tick();
        Assert.assertEquals((long)0L, (long)over.get());
        Assert.assertEquals((long)1L, (long)tick.get());
        Assert.assertEquals((long)1L, (long)under.get());
        fakeReturn.set(true);
        storeMonitor.tick();
        Assert.assertEquals((long)1L, (long)over.get());
        Assert.assertEquals((long)2L, (long)tick.get());
        Assert.assertEquals((long)1L, (long)under.get());
    }

    @Test
    public void testScheduler() throws Exception {
        FileStoreMonitor storeMonitor = new FileStoreMonitor(this.scheduledExecutorService, (Executor)this.executorService, 20L, TimeUnit.MILLISECONDS, 0.9);
        final ReusableLatch latch = new ReusableLatch(5);
        storeMonitor.addStore(this.getTestDirfile());
        storeMonitor.addCallback(new FileStoreMonitor.Callback(){

            public void tick(FileStore store, double usage) {
                System.out.println("TickS::" + usage);
                latch.countDown();
            }

            public void over(FileStore store, double usage) {
            }

            public void under(FileStore store, double usage) {
            }
        });
        storeMonitor.start();
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        storeMonitor.stop();
        latch.setCount(1);
        Assert.assertFalse((boolean)latch.await(100L, TimeUnit.MILLISECONDS));
    }
}

