/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.jdbc.store.drivers.oracle.Oracle12CSQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Test;

public class DatabaseStoreConfigurationTest
extends ActiveMQTestBase {
    @Test
    public void databaseStoreConfigTest() throws Exception {
        Configuration configuration = this.createConfiguration("database-store-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        DatabaseStoreConfigurationTest.assertEquals((Object)StoreConfiguration.StoreType.DATABASE, (Object)server.getConfiguration().getStoreConfiguration().getStoreType());
    }

    @Test
    public void testOracle12TableSize() {
        for (SQLProvider.DatabaseStoreType storeType : SQLProvider.DatabaseStoreType.values()) {
            Throwable rte = null;
            try {
                new Oracle12CSQLProvider.Factory().create("_A_TABLE_NAME_THAT_IS_TOO_LONG_", storeType);
            }
            catch (Throwable t) {
                rte = t;
            }
            DatabaseStoreConfigurationTest.assertNotNull((Object)rte);
            DatabaseStoreConfigurationTest.assertTrue((boolean)rte.getMessage().contains("The maximum name size for the " + storeType.name().toLowerCase() + " store table, when using Oracle12C is 30 characters."));
        }
    }

    protected Configuration createConfiguration(String fileName) throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(fileName);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        fc.setPagingDirectory(this.getTestDir() + "/" + fc.getPagingDirectory());
        fc.setLargeMessagesDirectory(this.getTestDir() + "/" + fc.getLargeMessagesDirectory());
        fc.setJournalDirectory(this.getTestDir() + "/" + fc.getJournalDirectory());
        fc.setBindingsDirectory(this.getTestDir() + "/" + fc.getBindingsDirectory());
        return fc;
    }
}

