/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.impl;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.impl.BroadcastGroupImpl;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class BroadcastGroupImplTest
extends ActiveMQTestBase {
    @Test
    public void testBroadcastDatagramLength() throws Throwable {
        BroadcastEndpointFactoryImpl befi = new BroadcastEndpointFactoryImpl();
        InVMNodeManager node = new InVMNodeManager(false);
        String name = "BroadcastGroupImplTest";
        BroadcastGroupImpl test = new BroadcastGroupImpl((NodeManager)node, name, 1000L, null, (BroadcastEndpointFactory)befi);
        TransportConfiguration tcon = new TransportConfiguration(((Object)((Object)this)).getClass().getName());
        test.addConnector(tcon);
        test.broadcastConnectors();
        BroadcastGroupImplTest.assertEquals((String)"Incorrect number of sent datagrams", (long)1L, (long)befi.sent);
    }

    static class BroadcastEndpointImpl
    implements BroadcastEndpoint {
        private BroadcastEndpointFactoryImpl factory;

        BroadcastEndpointImpl(BroadcastEndpointFactoryImpl factory) {
            this.factory = factory;
        }

        public void openClient() {
        }

        public void openBroadcaster() {
        }

        public void close(boolean isBroadcast) {
        }

        public void broadcast(byte[] data) throws Exception {
            if (data == null) {
                Assert.fail((String)"Attempted to send datagram with null content");
            }
            if (data.length == 0) {
                Assert.fail((String)"Attempted to send datagram with blank content");
            }
            if (data.length > 1500) {
                Assert.fail((String)("Attempted to send a datagram with " + data.length + " bytes"));
            }
            ++this.factory.sent;
        }

        public byte[] receiveBroadcast() throws Exception {
            return null;
        }

        public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
            return null;
        }
    }

    static class BroadcastEndpointFactoryImpl
    implements BroadcastEndpointFactory {
        private static final long serialVersionUID = 1L;
        int sent = 0;

        BroadcastEndpointFactoryImpl() {
        }

        public BroadcastEndpoint createBroadcastEndpoint() throws Exception {
            return new BroadcastEndpointImpl(this);
        }
    }
}

