/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.reload;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.reload.ReloadCallback;
import org.apache.activemq.artemis.core.server.reload.ReloadManagerImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReloadManagerTest
extends ActiveMQTestBase {
    private ScheduledExecutorService scheduledExecutorService;
    private ExecutorService executorService;
    private ReloadManagerImpl manager;

    @Before
    public void startScheduled() {
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(5);
        this.executorService = Executors.newSingleThreadExecutor();
        this.manager = new ReloadManagerImpl(this.scheduledExecutorService, (Executor)this.executorService, 100L);
    }

    @After
    public void stopScheduled() {
        this.manager.stop();
        this.scheduledExecutorService.shutdown();
        this.executorService.shutdown();
        this.scheduledExecutorService = null;
    }

    @Test
    public void testUpdate() throws Exception {
        File file = new File(this.getTemporaryDir(), "checkFile.tst");
        this.internalTest(this.manager, file);
    }

    @Test
    public void testUpdateWithSpace() throws Exception {
        File spaceDir = new File(this.getTemporaryDir(), "./with %25space");
        spaceDir.mkdirs();
        File file = new File(spaceDir, "checkFile.tst");
        this.internalTest(this.manager, file);
    }

    private void internalTest(ReloadManagerImpl manager, File file) throws IOException, InterruptedException {
        file.createNewFile();
        final ReusableLatch latch = new ReusableLatch(1);
        manager.addCallback(file.toURL(), new ReloadCallback(){

            public void reload(URL uri) {
                latch.countDown();
            }
        });
        Assert.assertFalse((boolean)latch.await(1L, TimeUnit.SECONDS));
        file.setLastModified(System.currentTimeMillis());
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
    }
}

