/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.jaas;

import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=1024)})
@ApplyLdifFiles(value={"test.ldif"})
public class LDAPLoginModuleTest
extends AbstractLdapTestUnit {
    private static final String PRINCIPAL = "uid=admin,ou=system";
    private static final String CREDENTIALS = "secret";
    private final String loginConfigSysPropName = "java.security.auth.login.config";
    private String oldLoginConfig;

    @Before
    public void setLoginConfigSysProperty() {
        this.oldLoginConfig = System.getProperty("java.security.auth.login.config", null);
        System.setProperty("java.security.auth.login.config", "src/test/resources/login.config");
    }

    @After
    public void resetLoginConfigSysProperty() {
        if (this.oldLoginConfig != null) {
            System.setProperty("java.security.auth.login.config", this.oldLoginConfig);
        }
    }

    @Test
    public void testRunning() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ldap://localhost:1024");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", PRINCIPAL);
        env.put("java.naming.security.credentials", CREDENTIALS);
        InitialDirContext ctx = new InitialDirContext(env);
        HashSet<String> set = new HashSet<String>();
        NamingEnumeration<NameClassPair> list = ctx.list("ou=system");
        while (list.hasMore()) {
            NameClassPair ncp = list.next();
            set.add(ncp.getName());
        }
        Assert.assertTrue((boolean)set.contains("uid=admin"));
        Assert.assertTrue((boolean)set.contains("ou=users"));
        Assert.assertTrue((boolean)set.contains("ou=groups"));
        Assert.assertTrue((boolean)set.contains("ou=configuration"));
        Assert.assertTrue((boolean)set.contains("prefNodeName=sysPrefRoot"));
    }

    @Test
    public void testLogin() throws LoginException {
        LoginContext context = new LoginContext("LDAPLogin", new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName("first");
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(LDAPLoginModuleTest.CREDENTIALS.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
            }
        });
        context.login();
        context.logout();
    }

    @Test
    public void testUnauthenticated() throws LoginException {
        LoginContext context = new LoginContext("UnAuthenticatedLDAPLogin", new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName("first");
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(LDAPLoginModuleTest.CREDENTIALS.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
            }
        });
        try {
            context.login();
        }
        catch (LoginException le) {
            Assert.assertEquals((Object)le.getCause().getMessage(), (Object)"Empty password is not allowed");
            return;
        }
        Assert.fail((String)"Should have failed authenticating");
    }
}

