/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Hashtable;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=1024)})
@ApplyLdifFiles(value={"test.ldif"})
public class LDAPModuleRoleExpansionTest
extends AbstractLdapTestUnit {
    private static final String PRINCIPAL = "uid=admin,ou=system";
    private static final String CREDENTIALS = "secret";
    private final String loginConfigSysPropName = "java.security.auth.login.config";
    private String oldLoginConfig;

    @Before
    public void setLoginConfigSysProperty() {
        this.oldLoginConfig = System.getProperty("java.security.auth.login.config", null);
        System.setProperty("java.security.auth.login.config", "src/test/resources/login.config");
    }

    @After
    public void resetLoginConfigSysProperty() {
        if (this.oldLoginConfig != null) {
            System.setProperty("java.security.auth.login.config", this.oldLoginConfig);
        }
    }

    @Test
    public void testRunning() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ldap://localhost:1024");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", PRINCIPAL);
        env.put("java.naming.security.credentials", CREDENTIALS);
        InitialDirContext ctx = new InitialDirContext(env);
        HashSet<String> set = new HashSet<String>();
        NamingEnumeration<NameClassPair> list = ctx.list("ou=system");
        while (list.hasMore()) {
            NameClassPair ncp = list.next();
            set.add(ncp.getName());
        }
        Assert.assertTrue((boolean)set.contains("uid=admin"));
        Assert.assertTrue((boolean)set.contains("ou=users"));
        Assert.assertTrue((boolean)set.contains("ou=groups"));
        Assert.assertTrue((boolean)set.contains("ou=configuration"));
        Assert.assertTrue((boolean)set.contains("prefNodeName=sysPrefRoot"));
    }

    @Test
    public void testRoleExpansion() throws LoginException {
        LoginContext context = new LoginContext("ExpandedLDAPLogin", new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName("first");
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(LDAPModuleRoleExpansionTest.CREDENTIALS.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
            }
        });
        context.login();
        Subject subject = context.getSubject();
        boolean isAdmin = false;
        boolean isUser = false;
        for (Principal principal : subject.getPrincipals()) {
            if (!(principal instanceof RolePrincipal)) continue;
            RolePrincipal groupPrincipal = (RolePrincipal)principal;
            if (groupPrincipal.getName().equalsIgnoreCase("admins")) {
                isAdmin = true;
            }
            if (!groupPrincipal.getName().equalsIgnoreCase("users")) continue;
            isUser = true;
        }
        Assert.assertTrue((isAdmin && isUser ? 1 : 0) != 0);
        context.logout();
    }
}

