/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.jaas;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.activemq.artemis.spi.core.security.jaas.JaasCallbackHandler;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoader;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoginModule;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

public class PropertiesLoginModuleRaceConditionTest {
    private static final String ROLES_FILE = "roles.properties";
    private static final String USERS_FILE = "users.properties";
    private static final String USERNAME = "first";
    private static final String PASSWORD = "secret";
    @Rule
    public final ErrorCollector e = new ErrorCollector();
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    @Rule
    public final TestName name = new TestName();
    private Map<String, String> options;
    private BlockingQueue<Exception> errors;
    private ExecutorService pool;
    private CallbackHandler callback;

    @Before
    public void before() throws FileNotFoundException, IOException {
        this.createUsers();
        this.createGroups();
        this.options = new HashMap<String, String>();
        this.options.put("reload", "true");
        this.options.put("org.apache.activemq.jaas.properties.user", USERS_FILE);
        this.options.put("org.apache.activemq.jaas.properties.role", ROLES_FILE);
        this.options.put("baseDir", this.temp.getRoot().getAbsolutePath());
        this.errors = new ArrayBlockingQueue<Exception>(this.processorCount());
        this.pool = Executors.newFixedThreadPool(this.processorCount(), (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        this.callback = new JaasCallbackHandler(USERNAME, PASSWORD, null);
    }

    @After
    public void after() throws InterruptedException {
        this.pool.shutdown();
        Assert.assertTrue((boolean)this.pool.awaitTermination(500L, TimeUnit.SECONDS));
        PropertiesLoader.resetUsersAndGroupsCache();
    }

    @Test
    public void raceConditionInUsersAndGroupsLoading() throws InterruptedException, FileNotFoundException, IOException {
        for (int i = 0; i < 25000; ++i) {
            CountDownLatch start = new CountDownLatch(1);
            CountDownLatch finished = new CountDownLatch(this.processorCount());
            this.prepareLoginThreads(start, finished);
            start.countDown();
            finished.await();
            if (!this.isRaceConditionDetected()) continue;
            this.e.addError((Throwable)((Object)new AssertionError((Object)"At least one race condition in PropertiesLoginModule has been encountered. Please examine the following stack traces for more details:")));
            for (Exception exception : this.errors) {
                this.e.addError((Throwable)exception);
            }
            return;
        }
    }

    private boolean isRaceConditionDetected() {
        return this.errors.size() > 0;
    }

    private void prepareLoginThreads(CountDownLatch start, CountDownLatch finished) {
        for (int processor = 1; processor <= this.processorCount() * 2; ++processor) {
            this.pool.submit(new LoginTester(start, finished, this.errors, this.options, this.callback));
        }
    }

    private int processorCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    private void store(Properties from, File to) throws FileNotFoundException, IOException {
        try (FileOutputStream output = new FileOutputStream(to);){
            from.store(output, "Generated by " + this.name.getMethodName());
        }
    }

    private void createGroups() throws FileNotFoundException, IOException {
        Properties groups = new Properties();
        for (int i = 0; i < 100; ++i) {
            groups.put("group" + i, "first,second,third");
        }
        this.store(groups, this.temp.newFile(ROLES_FILE));
    }

    private void createUsers() throws FileNotFoundException, IOException {
        Properties users = new Properties();
        users.put(USERNAME, PASSWORD);
        users.put("second", PASSWORD);
        users.put("third", PASSWORD);
        this.store(users, this.temp.newFile(USERS_FILE));
    }

    private static class LoginTester
    implements Runnable {
        private final CountDownLatch finished;
        private final BlockingQueue<Exception> errors;
        private final Map<String, String> options;
        private final CountDownLatch start;
        private final CallbackHandler callback;

        LoginTester(CountDownLatch start, CountDownLatch finished, BlockingQueue<Exception> errors, Map<String, String> options, CallbackHandler callbackHandler) {
            this.finished = finished;
            this.errors = errors;
            this.options = options;
            this.start = start;
            this.callback = callbackHandler;
        }

        @Override
        public void run() {
            try {
                this.start.await();
                Subject subject = new Subject();
                PropertiesLoginModule module = new PropertiesLoginModule();
                module.initialize(subject, this.callback, new HashMap(), this.options);
                module.login();
                module.commit();
            }
            catch (Exception e) {
                this.errors.offer(e);
            }
            finally {
                this.finished.countDown();
            }
        }
    }
}

