/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.jaas;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.cert.X509Certificate;
import org.apache.activemq.artemis.core.security.jaas.StubX509Certificate;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.JaasCallbackHandler;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoader;
import org.apache.activemq.artemis.spi.core.security.jaas.TextFileCertificateLoginModule;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TextFileCertificateLoginModuleTest {
    private static final Logger logger;
    private static final String CERT_USERS_FILE_SMALL = "cert-users-SMALL.properties";
    private static final String CERT_USERS_FILE_LARGE = "cert-users-LARGE.properties";
    private static final String CERT_GROUPS_FILE = "cert-roles.properties";
    private static final int NUMBER_SUBJECTS = 10;
    private CertificateLoginModule loginModule;

    @Before
    public void setUp() throws Exception {
        this.loginModule = new TextFileCertificateLoginModule();
    }

    @After
    public void tearDown() throws Exception {
        PropertiesLoader.resetUsersAndGroupsCache();
    }

    @Test
    public void testLoginWithSMALLUsersFile() throws Exception {
        this.loginTest(CERT_USERS_FILE_SMALL, CERT_GROUPS_FILE);
    }

    @Test
    public void testLoginWithLARGEUsersFile() throws Exception {
        this.loginTest(CERT_USERS_FILE_LARGE, CERT_GROUPS_FILE);
    }

    private void loginTest(String usersFiles, String groupsFile) throws LoginException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.apache.activemq.jaas.textfiledn.user", usersFiles);
        options.put("org.apache.activemq.jaas.textfiledn.role", groupsFile);
        options.put("reload", "true");
        JaasCallbackHandler[] callbackHandlers = new JaasCallbackHandler[10];
        Subject[] subjects = new Subject[10];
        for (int i = 0; i < callbackHandlers.length; ++i) {
            callbackHandlers[i] = this.getJaasCertificateCallbackHandler("DN=TEST_USER_" + (i + 1));
        }
        long startTime = System.currentTimeMillis();
        for (int outer = 0; outer < 500; ++outer) {
            for (int i = 0; i < 10; ++i) {
                Subject subject;
                subjects[i] = subject = this.doAuthenticate(options, callbackHandlers[i]);
            }
        }
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        for (int i = 0; i < 10; ++i) {
            ActiveMQServerLogger.LOGGER.info((Object)("subject is: " + subjects[i].getPrincipals().toString()));
        }
        ActiveMQServerLogger.LOGGER.info((Object)(usersFiles + ": Time taken is " + timeTaken));
    }

    private JaasCallbackHandler getJaasCertificateCallbackHandler(String user) {
        JMXPrincipal principal = new JMXPrincipal(user);
        StubX509Certificate cert = new StubX509Certificate(principal);
        return new JaasCallbackHandler(null, null, new X509Certificate[]{cert});
    }

    private Subject doAuthenticate(HashMap<String, ?> options, JaasCallbackHandler callbackHandler) throws LoginException {
        Subject mySubject = new Subject();
        this.loginModule.initialize(mySubject, (CallbackHandler)callbackHandler, null, options);
        this.loginModule.login();
        this.loginModule.commit();
        return mySubject;
    }

    static {
        URL resource;
        logger = Logger.getLogger(TextFileCertificateLoginModuleTest.class);
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = TextFileCertificateLoginModuleTest.class.getClassLoader().getResource("login.config")) != null) {
            try {
                path = URLDecoder.decode(resource.getFile(), StandardCharsets.UTF_8.name());
                System.setProperty("java.security.auth.login.config", path);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

