/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EmbeddedServerTest {
    private static final String SERVER_LOCK_NAME = "server.lock";
    private static final String SERVER_JOURNAL_DIR = "target/data/journal";
    private ActiveMQServer server;
    private Configuration configuration;

    @Before
    public void setup() {
        this.configuration = new ConfigurationImpl().setJournalDirectory(SERVER_JOURNAL_DIR).setPersistenceEnabled(false).setSecurityEnabled(false).addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName()));
        this.server = ActiveMQServers.newActiveMQServer((Configuration)this.configuration);
        try {
            this.server.start();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @After
    public void teardown() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNoLockFileWithPersistenceFalse() {
        Path journalDir = Paths.get(SERVER_JOURNAL_DIR, SERVER_LOCK_NAME);
        boolean lockExists = Files.exists(journalDir, new LinkOption[0]);
        Assert.assertFalse((boolean)lockExists);
    }
}

