/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.jaas;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.commons.io.FileUtils;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class PropertiesLoginModuleTest
extends Assert {
    private static final Logger logger;

    @Test
    public void testLogin() throws LoginException {
        LoginContext context = new LoginContext("PropertiesLogin", new UserPassHandler("first", "secret"));
        context.login();
        Subject subject = context.getSubject();
        PropertiesLoginModuleTest.assertEquals((String)"Should have three principals", (long)3L, (long)subject.getPrincipals().size());
        PropertiesLoginModuleTest.assertEquals((String)"Should have one user principal", (long)1L, (long)subject.getPrincipals(UserPrincipal.class).size());
        PropertiesLoginModuleTest.assertEquals((String)"Should have two group principals", (long)2L, (long)subject.getPrincipals(RolePrincipal.class).size());
        context.logout();
        PropertiesLoginModuleTest.assertEquals((String)"Should have zero principals", (long)0L, (long)subject.getPrincipals().size());
    }

    @Test
    public void testLoginReload() throws Exception {
        File targetPropDir = new File("target/loginReloadTest");
        File usersFile = new File(targetPropDir, "users.properties");
        File rolesFile = new File(targetPropDir, "roles.properties");
        FileUtils.copyFile((File)new File(((Object)((Object)this)).getClass().getResource("/users.properties").toURI()), (File)usersFile);
        FileUtils.copyFile((File)new File(((Object)((Object)this)).getClass().getResource("/roles.properties").toURI()), (File)rolesFile);
        LoginContext context = new LoginContext("PropertiesLoginReload", new UserPassHandler("first", "secret"));
        context.login();
        Subject subject = context.getSubject();
        PropertiesLoginModuleTest.assertEquals((String)"Should have three principals", (long)3L, (long)subject.getPrincipals().size());
        PropertiesLoginModuleTest.assertEquals((String)"Should have one user principal", (long)1L, (long)subject.getPrincipals(UserPrincipal.class).size());
        PropertiesLoginModuleTest.assertEquals((String)"Should have two group principals", (long)2L, (long)subject.getPrincipals(RolePrincipal.class).size());
        context.logout();
        PropertiesLoginModuleTest.assertEquals((String)"Should have zero principals", (long)0L, (long)subject.getPrincipals().size());
        Thread.sleep(1000L);
        FileUtils.copyFile((File)new File(((Object)((Object)this)).getClass().getResource("/usersReload.properties").toURI()), (File)usersFile);
        FileUtils.copyFile((File)new File(((Object)((Object)this)).getClass().getResource("/rolesReload.properties").toURI()), (File)rolesFile);
        FileUtils.touch((File)usersFile);
        FileUtils.touch((File)rolesFile);
        context = new LoginContext("PropertiesLoginReload", new UserPassHandler("first", "secrets"));
        context.login();
        subject = context.getSubject();
        PropertiesLoginModuleTest.assertEquals((String)"Should have three principals", (long)2L, (long)subject.getPrincipals().size());
        PropertiesLoginModuleTest.assertEquals((String)"Should have one user principal", (long)1L, (long)subject.getPrincipals(UserPrincipal.class).size());
        PropertiesLoginModuleTest.assertEquals((String)"Should have one group principals", (long)1L, (long)subject.getPrincipals(RolePrincipal.class).size());
        context.logout();
        PropertiesLoginModuleTest.assertEquals((String)"Should have zero principals", (long)0L, (long)subject.getPrincipals().size());
    }

    @Test
    public void testBadUseridLogin() throws Exception {
        LoginContext context = new LoginContext("PropertiesLogin", new UserPassHandler("BAD", "secret"));
        try {
            context.login();
            PropertiesLoginModuleTest.fail((String)"Should have thrown a FailedLoginException");
        }
        catch (FailedLoginException failedLoginException) {
            // empty catch block
        }
    }

    @Test
    public void testBadPWLogin() throws Exception {
        LoginContext context = new LoginContext("PropertiesLogin", new UserPassHandler("first", "BAD"));
        try {
            context.login();
            PropertiesLoginModuleTest.fail((String)"Should have thrown a FailedLoginException");
        }
        catch (FailedLoginException failedLoginException) {
            // empty catch block
        }
    }

    static {
        URL resource;
        logger = Logger.getLogger(PropertiesLoginModuleTest.class);
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = PropertiesLoginModuleTest.class.getClassLoader().getResource("login.config")) != null) {
            try {
                path = URLDecoder.decode(resource.getFile(), StandardCharsets.UTF_8.name());
                System.setProperty("java.security.auth.login.config", path);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private static class UserPassHandler
    implements CallbackHandler {
        private final String user;
        private final String pass;

        private UserPassHandler(String user, String pass) {
            this.user = user;
            this.pass = pass;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName(this.user);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword(this.pass.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i]);
            }
        }
    }
}

