/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigurationImplTest
extends ActiveMQTestBase {
    protected Configuration conf;

    @Test
    public void testDefaults() {
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize(), (long)this.conf.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultSecurityInvalidationInterval(), (long)this.conf.getSecurityInvalidationInterval());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultSecurityEnabled(), (Object)this.conf.isSecurityEnabled());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultBindingsDirectory(), (Object)this.conf.getBindingsDirectory());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultCreateBindingsDir(), (Object)this.conf.isCreateBindingsDir());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultJournalDir(), (Object)this.conf.getJournalDirectory());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultCreateJournalDir(), (Object)this.conf.isCreateJournalDir());
        Assert.assertEquals((Object)ConfigurationImpl.DEFAULT_JOURNAL_TYPE, (Object)this.conf.getJournalType());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultJournalSyncTransactional(), (Object)this.conf.isJournalSyncTransactional());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultJournalSyncNonTransactional(), (Object)this.conf.isJournalSyncNonTransactional());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalFileSize(), (long)this.conf.getJournalFileSize());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalMinFiles(), (long)this.conf.getJournalMinFiles());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalMaxIoAio(), (long)this.conf.getJournalMaxIO_AIO());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalMaxIoNio(), (long)this.conf.getJournalMaxIO_NIO());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultWildcardRoutingEnabled(), (Object)this.conf.isWildcardRoutingEnabled());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultTransactionTimeout(), (long)this.conf.getTransactionTimeout());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultMessageExpiryScanPeriod(), (long)this.conf.getMessageExpiryScanPeriod());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultMessageExpiryThreadPriority(), (long)this.conf.getMessageExpiryThreadPriority());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultTransactionTimeoutScanPeriod(), (long)this.conf.getTransactionTimeoutScanPeriod());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultManagementAddress(), (Object)this.conf.getManagementAddress());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress(), (Object)this.conf.getManagementNotificationAddress());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultClusterUser(), (Object)this.conf.getClusterUser());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultClusterPassword(), (Object)this.conf.getClusterPassword());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultPersistenceEnabled(), (Object)this.conf.isPersistenceEnabled());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultPersistDeliveryCountBeforeDelivery(), (Object)this.conf.isPersistDeliveryCountBeforeDelivery());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultFileDeployerScanPeriod(), (long)this.conf.getFileDeployerScanPeriod());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultThreadPoolMaxSize(), (long)this.conf.getThreadPoolMaxSize());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultJmxManagementEnabled(), (Object)this.conf.isJMXManagementEnabled());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultConnectionTtlOverride(), (long)this.conf.getConnectionTTLOverride());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultAsyncConnectionExecutionEnabled(), (Object)this.conf.isAsyncConnectionExecutionEnabled());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultPagingDir(), (Object)this.conf.getPagingDirectory());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultLargeMessagesDir(), (Object)this.conf.getLargeMessagesDirectory());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalCompactPercentage(), (long)this.conf.getJournalCompactPercentage());
        Assert.assertEquals((long)500000L, (long)this.conf.getJournalBufferTimeout_AIO());
        Assert.assertEquals((long)3333333L, (long)this.conf.getJournalBufferTimeout_NIO());
        Assert.assertEquals((long)501760L, (long)this.conf.getJournalBufferSize_AIO());
        Assert.assertEquals((long)501760L, (long)this.conf.getJournalBufferSize_NIO());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultJournalLogWriteRate(), (Object)this.conf.isLogJournalWriteRate());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalPerfBlastPages(), (long)this.conf.getJournalPerfBlastPages());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultMessageCounterEnabled(), (Object)this.conf.isMessageCounterEnabled());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultMessageCounterMaxDayHistory(), (long)this.conf.getMessageCounterMaxDayHistory());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultMessageCounterSamplePeriod(), (long)this.conf.getMessageCounterSamplePeriod());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultIdCacheSize(), (long)this.conf.getIDCacheSize());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultPersistIdCache(), (Object)this.conf.isPersistIDCache());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultServerDumpInterval(), (long)this.conf.getServerDumpInterval());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultMemoryWarningThreshold(), (long)this.conf.getMemoryWarningThreshold());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultMemoryMeasureInterval(), (long)this.conf.getMemoryMeasureInterval());
    }

    @Test
    public void testSetGetAttributes() throws Exception {
        for (int j = 0; j < 100; ++j) {
            int i = RandomUtil.randomInt();
            this.conf.setScheduledThreadPoolMaxSize(i);
            Assert.assertEquals((long)i, (long)this.conf.getScheduledThreadPoolMaxSize());
            long l = RandomUtil.randomLong();
            this.conf.setSecurityInvalidationInterval(l);
            Assert.assertEquals((long)l, (long)this.conf.getSecurityInvalidationInterval());
            boolean b = RandomUtil.randomBoolean();
            this.conf.setSecurityEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isSecurityEnabled());
            String s = RandomUtil.randomString();
            this.conf.setBindingsDirectory(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getBindingsDirectory());
            b = RandomUtil.randomBoolean();
            this.conf.setCreateBindingsDir(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isCreateBindingsDir());
            s = RandomUtil.randomString();
            this.conf.setJournalDirectory(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getJournalDirectory());
            b = RandomUtil.randomBoolean();
            this.conf.setCreateJournalDir(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isCreateJournalDir());
            i = RandomUtil.randomInt() % 2;
            JournalType journal = i == 0 ? JournalType.ASYNCIO : JournalType.NIO;
            this.conf.setJournalType(journal);
            Assert.assertEquals((Object)journal, (Object)this.conf.getJournalType());
            b = RandomUtil.randomBoolean();
            this.conf.setJournalSyncTransactional(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isJournalSyncTransactional());
            b = RandomUtil.randomBoolean();
            this.conf.setJournalSyncNonTransactional(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isJournalSyncNonTransactional());
            i = RandomUtil.randomInt();
            this.conf.setJournalFileSize(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalFileSize());
            i = RandomUtil.randomInt();
            this.conf.setJournalMinFiles(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalMinFiles());
            i = RandomUtil.randomInt();
            this.conf.setJournalMaxIO_AIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalMaxIO_AIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalMaxIO_NIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalMaxIO_NIO());
            s = RandomUtil.randomString();
            this.conf.setManagementAddress(new SimpleString(s));
            Assert.assertEquals((Object)s, (Object)this.conf.getManagementAddress().toString());
            i = RandomUtil.randomInt();
            this.conf.setMessageExpiryThreadPriority(i);
            Assert.assertEquals((long)i, (long)this.conf.getMessageExpiryThreadPriority());
            l = RandomUtil.randomLong();
            this.conf.setMessageExpiryScanPeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getMessageExpiryScanPeriod());
            b = RandomUtil.randomBoolean();
            this.conf.setPersistDeliveryCountBeforeDelivery(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isPersistDeliveryCountBeforeDelivery());
            b = RandomUtil.randomBoolean();
            this.conf.setEnabledAsyncConnectionExecution(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isAsyncConnectionExecutionEnabled());
            b = RandomUtil.randomBoolean();
            this.conf.setPersistenceEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isPersistenceEnabled());
            b = RandomUtil.randomBoolean();
            this.conf.setJMXManagementEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isJMXManagementEnabled());
            l = RandomUtil.randomLong();
            this.conf.setFileDeployerScanPeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getFileDeployerScanPeriod());
            l = RandomUtil.randomLong();
            this.conf.setConnectionTTLOverride(l);
            Assert.assertEquals((long)l, (long)this.conf.getConnectionTTLOverride());
            i = RandomUtil.randomInt();
            this.conf.setThreadPoolMaxSize(i);
            Assert.assertEquals((long)i, (long)this.conf.getThreadPoolMaxSize());
            SimpleString ss = RandomUtil.randomSimpleString();
            this.conf.setManagementNotificationAddress(ss);
            Assert.assertEquals((Object)ss, (Object)this.conf.getManagementNotificationAddress());
            s = RandomUtil.randomString();
            this.conf.setClusterUser(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getClusterUser());
            i = RandomUtil.randomInt();
            this.conf.setIDCacheSize(i);
            Assert.assertEquals((long)i, (long)this.conf.getIDCacheSize());
            b = RandomUtil.randomBoolean();
            this.conf.setPersistIDCache(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isPersistIDCache());
            i = RandomUtil.randomInt();
            this.conf.setJournalCompactMinFiles(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalCompactMinFiles());
            i = RandomUtil.randomInt();
            this.conf.setJournalCompactPercentage(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalCompactPercentage());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferSize_AIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalBufferSize_AIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferTimeout_AIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalBufferTimeout_AIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferSize_NIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalBufferSize_NIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferTimeout_NIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalBufferTimeout_NIO());
            b = RandomUtil.randomBoolean();
            this.conf.setLogJournalWriteRate(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isLogJournalWriteRate());
            i = RandomUtil.randomInt();
            this.conf.setJournalPerfBlastPages(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalPerfBlastPages());
            l = RandomUtil.randomLong();
            this.conf.setServerDumpInterval(l);
            Assert.assertEquals((long)l, (long)this.conf.getServerDumpInterval());
            s = RandomUtil.randomString();
            this.conf.setPagingDirectory(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getPagingDirectory());
            s = RandomUtil.randomString();
            this.conf.setLargeMessagesDirectory(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getLargeMessagesDirectory());
            b = RandomUtil.randomBoolean();
            this.conf.setWildcardRoutingEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isWildcardRoutingEnabled());
            l = RandomUtil.randomLong();
            this.conf.setTransactionTimeout(l);
            Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeout());
            b = RandomUtil.randomBoolean();
            this.conf.setMessageCounterEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isMessageCounterEnabled());
            l = RandomUtil.randomPositiveLong();
            this.conf.setMessageCounterSamplePeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getMessageCounterSamplePeriod());
            i = RandomUtil.randomInt();
            this.conf.setMessageCounterMaxDayHistory(i);
            Assert.assertEquals((long)i, (long)this.conf.getMessageCounterMaxDayHistory());
            l = RandomUtil.randomLong();
            this.conf.setTransactionTimeoutScanPeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeoutScanPeriod());
            s = RandomUtil.randomString();
            this.conf.setClusterPassword(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getClusterPassword());
        }
    }

    @Test
    public void testGetSetInterceptors() {
        String name1 = "uqwyuqywuy";
        String name2 = "yugyugyguyg";
        this.conf.getIncomingInterceptorClassNames().add("uqwyuqywuy");
        this.conf.getIncomingInterceptorClassNames().add("yugyugyguyg");
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("uqwyuqywuy"));
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("yugyugyguyg"));
        Assert.assertFalse((boolean)this.conf.getIncomingInterceptorClassNames().contains("iijij"));
    }

    @Test
    public void testSerialize() throws Exception {
        boolean b = RandomUtil.randomBoolean();
        this.conf.setHAPolicyConfiguration((HAPolicyConfiguration)new LiveOnlyPolicyConfiguration());
        int i = RandomUtil.randomInt();
        this.conf.setScheduledThreadPoolMaxSize(i);
        Assert.assertEquals((long)i, (long)this.conf.getScheduledThreadPoolMaxSize());
        long l = RandomUtil.randomLong();
        this.conf.setSecurityInvalidationInterval(l);
        Assert.assertEquals((long)l, (long)this.conf.getSecurityInvalidationInterval());
        b = RandomUtil.randomBoolean();
        this.conf.setSecurityEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isSecurityEnabled());
        String s = RandomUtil.randomString();
        this.conf.setBindingsDirectory(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getBindingsDirectory());
        b = RandomUtil.randomBoolean();
        this.conf.setCreateBindingsDir(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isCreateBindingsDir());
        s = RandomUtil.randomString();
        this.conf.setJournalDirectory(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getJournalDirectory());
        b = RandomUtil.randomBoolean();
        this.conf.setCreateJournalDir(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isCreateJournalDir());
        i = RandomUtil.randomInt() % 2;
        JournalType journal = i == 0 ? JournalType.ASYNCIO : JournalType.NIO;
        this.conf.setJournalType(journal);
        Assert.assertEquals((Object)journal, (Object)this.conf.getJournalType());
        b = RandomUtil.randomBoolean();
        this.conf.setJournalSyncTransactional(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isJournalSyncTransactional());
        b = RandomUtil.randomBoolean();
        this.conf.setJournalSyncNonTransactional(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isJournalSyncNonTransactional());
        i = RandomUtil.randomInt();
        this.conf.setJournalFileSize(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalFileSize());
        i = RandomUtil.randomInt();
        this.conf.setJournalMinFiles(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalMinFiles());
        i = RandomUtil.randomInt();
        this.conf.setJournalMaxIO_AIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalMaxIO_AIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalMaxIO_NIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalMaxIO_NIO());
        s = RandomUtil.randomString();
        this.conf.setManagementAddress(new SimpleString(s));
        Assert.assertEquals((Object)s, (Object)this.conf.getManagementAddress().toString());
        i = RandomUtil.randomInt();
        this.conf.setMessageExpiryThreadPriority(i);
        Assert.assertEquals((long)i, (long)this.conf.getMessageExpiryThreadPriority());
        l = RandomUtil.randomLong();
        this.conf.setMessageExpiryScanPeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getMessageExpiryScanPeriod());
        b = RandomUtil.randomBoolean();
        this.conf.setPersistDeliveryCountBeforeDelivery(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isPersistDeliveryCountBeforeDelivery());
        b = RandomUtil.randomBoolean();
        this.conf.setEnabledAsyncConnectionExecution(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isAsyncConnectionExecutionEnabled());
        b = RandomUtil.randomBoolean();
        this.conf.setPersistenceEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isPersistenceEnabled());
        b = RandomUtil.randomBoolean();
        this.conf.setJMXManagementEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isJMXManagementEnabled());
        l = RandomUtil.randomLong();
        this.conf.setFileDeployerScanPeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getFileDeployerScanPeriod());
        l = RandomUtil.randomLong();
        this.conf.setConnectionTTLOverride(l);
        Assert.assertEquals((long)l, (long)this.conf.getConnectionTTLOverride());
        i = RandomUtil.randomInt();
        this.conf.setThreadPoolMaxSize(i);
        Assert.assertEquals((long)i, (long)this.conf.getThreadPoolMaxSize());
        SimpleString ss = RandomUtil.randomSimpleString();
        this.conf.setManagementNotificationAddress(ss);
        Assert.assertEquals((Object)ss, (Object)this.conf.getManagementNotificationAddress());
        s = RandomUtil.randomString();
        this.conf.setClusterUser(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getClusterUser());
        i = RandomUtil.randomInt();
        this.conf.setIDCacheSize(i);
        Assert.assertEquals((long)i, (long)this.conf.getIDCacheSize());
        b = RandomUtil.randomBoolean();
        this.conf.setPersistIDCache(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isPersistIDCache());
        i = RandomUtil.randomInt();
        this.conf.setJournalCompactMinFiles(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalCompactMinFiles());
        i = RandomUtil.randomInt();
        this.conf.setJournalCompactPercentage(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalCompactPercentage());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferSize_AIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalBufferSize_AIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferTimeout_AIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalBufferTimeout_AIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferSize_NIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalBufferSize_NIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferTimeout_NIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalBufferTimeout_NIO());
        b = RandomUtil.randomBoolean();
        this.conf.setLogJournalWriteRate(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isLogJournalWriteRate());
        i = RandomUtil.randomInt();
        this.conf.setJournalPerfBlastPages(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalPerfBlastPages());
        l = RandomUtil.randomLong();
        this.conf.setServerDumpInterval(l);
        Assert.assertEquals((long)l, (long)this.conf.getServerDumpInterval());
        s = RandomUtil.randomString();
        this.conf.setPagingDirectory(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getPagingDirectory());
        s = RandomUtil.randomString();
        this.conf.setLargeMessagesDirectory(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getLargeMessagesDirectory());
        b = RandomUtil.randomBoolean();
        this.conf.setWildcardRoutingEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isWildcardRoutingEnabled());
        l = RandomUtil.randomLong();
        this.conf.setTransactionTimeout(l);
        Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeout());
        b = RandomUtil.randomBoolean();
        this.conf.setMessageCounterEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isMessageCounterEnabled());
        l = RandomUtil.randomPositiveLong();
        this.conf.setMessageCounterSamplePeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getMessageCounterSamplePeriod());
        i = RandomUtil.randomInt();
        this.conf.setMessageCounterMaxDayHistory(i);
        Assert.assertEquals((long)i, (long)this.conf.getMessageCounterMaxDayHistory());
        l = RandomUtil.randomLong();
        this.conf.setTransactionTimeoutScanPeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeoutScanPeriod());
        s = RandomUtil.randomString();
        this.conf.setClusterPassword(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getClusterPassword());
        Configuration conf2 = this.conf.copy();
        Assert.assertTrue((boolean)this.conf.equals(conf2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolvePath() throws Throwable {
        String oldProperty = System.getProperty("artemis.instance");
        try {
            System.setProperty("artemis.instance", "/tmp/" + RandomUtil.randomString());
            ConfigurationImpl configuration = new ConfigurationImpl();
            configuration.setJournalDirectory("./data-journal");
            File journalLocation = configuration.getJournalLocation();
            Assert.assertFalse((String)"This path shouldn't resolve to a real folder", (boolean)journalLocation.exists());
        }
        finally {
            if (oldProperty == null) {
                System.clearProperty("artemis.instance");
            } else {
                System.setProperty("artemis.instance", oldProperty);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbsolutePath() throws Throwable {
        String oldProperty = System.getProperty("artemis.instance");
        File tempFolder = null;
        try {
            System.setProperty("artemis.instance", "/tmp/" + RandomUtil.randomString());
            tempFolder = File.createTempFile("journal-folder", "");
            tempFolder.delete();
            tempFolder = new File(tempFolder.getAbsolutePath());
            tempFolder.mkdirs();
            System.out.println("TempFolder = " + tempFolder.getAbsolutePath());
            ConfigurationImpl configuration = new ConfigurationImpl();
            configuration.setJournalDirectory(tempFolder.getAbsolutePath());
            File journalLocation = configuration.getJournalLocation();
            Assert.assertTrue((boolean)journalLocation.exists());
        }
        finally {
            if (oldProperty == null) {
                System.clearProperty("artemis.instance");
            } else {
                System.setProperty("artemis.instance", oldProperty);
            }
            if (tempFolder != null) {
                tempFolder.delete();
            }
        }
    }

    @Test
    public void testSetSystemProperty() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put(configuration.getSystemPropertyPrefix() + "fileDeployerScanPeriod", "1234");
        properties.put(configuration.getSystemPropertyPrefix() + "globalMaxSize", "4321");
        configuration.parseSystemProperties(properties);
        Assert.assertEquals((long)1234L, (long)configuration.getFileDeployerScanPeriod());
        Assert.assertEquals((long)4321L, (long)configuration.getGlobalMaxSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetSystemPropertyCME() throws Throwable {
        final Properties properties = new Properties();
        for (int i = 0; i < 5000; ++i) {
            properties.put("key" + i, "value " + i);
        }
        ConfigurationImpl configuration = new ConfigurationImpl();
        final AtomicBoolean running = new AtomicBoolean(true);
        final CountDownLatch latch = new CountDownLatch(1);
        Thread thread = new Thread(){

            @Override
            public void run() {
                latch.countDown();
                int i = 1;
                while (running.get()) {
                    properties.remove("key" + i);
                    properties.put("key" + i, "new value " + i);
                    if (++i <= 200) continue;
                    i = 1;
                }
            }
        };
        thread.start();
        try {
            latch.await();
            properties.put(configuration.getSystemPropertyPrefix() + "fileDeployerScanPeriod", "1234");
            properties.put(configuration.getSystemPropertyPrefix() + "globalMaxSize", "4321");
            configuration.parseSystemProperties(properties);
        }
        finally {
            running.set(false);
            thread.join();
        }
        Assert.assertEquals((long)1234L, (long)configuration.getFileDeployerScanPeriod());
        Assert.assertEquals((long)4321L, (long)configuration.getGlobalMaxSize());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conf = this.createConfiguration();
    }

    protected Configuration createConfiguration() throws Exception {
        return new ConfigurationImpl();
    }
}

