/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.deployers.impl.FileConfigurationParser;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXParseException;

public class FileConfigurationParserTest
extends ActiveMQTestBase {
    private static String firstPart = "<core xmlns=\"urn:activemq:core\">\n<name>ActiveMQ.main.config</name>\n<log-delegate-factory-class-name>org.apache.activemq.artemis.integration.logging.Log4jLogDelegateFactory</log-delegate-factory-class-name>\n<bindings-directory>${jboss.server.data.dir}/activemq/bindings</bindings-directory>\n<journal-directory>${jboss.server.data.dir}/activemq/journal</journal-directory>\n<journal-min-files>10</journal-min-files>\n<large-messages-directory>${jboss.server.data.dir}/activemq/largemessages</large-messages-directory>\n<paging-directory>${jboss.server.data.dir}/activemq/paging</paging-directory>\n<connectors>\n<connector name=\"netty\">tcp://localhost:61616</connector>\n<connector name=\"netty-throughput\">tcp://localhost:5545</connector>\n<connector name=\"in-vm\">vm://0</connector>\n</connectors>\n<acceptors>\n<acceptor name=\"netty\">tcp://localhost:5545</acceptor>\n<acceptor name=\"netty-throughput\">tcp://localhost:5545</acceptor>\n<acceptor name=\"in-vm\">vm://0</acceptor>\n</acceptors>\n<security-settings>\n<security-setting match=\"#\">\n<permission type=\"createNonDurableQueue\" roles=\"guest\"/>\n<permission type=\"deleteNonDurableQueue\" roles=\"guest\"/>\n<permission type=\"createDurableQueue\" roles=\"guest\"/>\n<permission type=\"deleteDurableQueue\" roles=\"guest\"/>\n<permission type=\"consume\" roles=\"guest\"/>\n<permission type=\"send\" roles=\"guest\"/>\n</security-setting>\n</security-settings>\n<address-settings>\n<address-setting match=\"#\">\n<dead-letter-address>jms.queue.DLQ\n</dead-letter-address>\n<expiry-address>jms.queue.ExpiryQueue\n</expiry-address>\n<redelivery-delay>0\n</redelivery-delay>\n<max-size-bytes>10485760\n</max-size-bytes>\n<message-counter-history-day-limit>10</message-counter-history-day-limit>\n<address-full-policy>BLOCK</address-full-policy>\n</address-setting>\n</address-settings>\n";
    private static String lastPart = "</core>";

    @Test
    public void testSchemaValidation() throws Exception {
        for (int i = 0; i < 7; ++i) {
            String filename = "InvalidConfigurationTest" + i + ".xml";
            FileConfiguration fc = new FileConfiguration();
            FileDeploymentManager deploymentManager = new FileDeploymentManager(filename);
            deploymentManager.addDeployable((Deployable)fc);
            try {
                deploymentManager.readConfiguration();
                FileConfigurationParserTest.fail((String)("parsing should have failed for " + filename));
                continue;
            }
            catch (IllegalStateException e) {
                Throwable cause = e.getCause();
                FileConfigurationParserTest.assertTrue((String)"must have been org.xml.sax.SAXParseException", (boolean)(cause instanceof SAXParseException));
            }
        }
    }

    @Test
    public void testDivertRoutingNameIsNotRequired() throws Exception {
        String filename = "divertRoutingNameNotRequired.xml";
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(filename);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
    }

    @Test
    public void testParsingClusterConnectionURIs() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        String configStr = firstPart + "<cluster-connections>\n" + "   <cluster-connection-uri name=\"my-cluster\" address=\"multicast://my-discovery-group?messageLoadBalancingType=STRICT;retryInterval=333;connectorName=netty-connector;maxHops=1\"/>\n" + "</cluster-connections>\n" + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration config = parser.parseMainConfig((InputStream)input);
        Assert.assertEquals((long)1L, (long)config.getClusterConfigurations().size());
        Assert.assertEquals((Object)"my-discovery-group", (Object)((ClusterConnectionConfiguration)config.getClusterConfigurations().get(0)).getDiscoveryGroupName());
        Assert.assertEquals((long)333L, (long)((ClusterConnectionConfiguration)config.getClusterConfigurations().get(0)).getRetryInterval());
    }

    @Test
    public void testParsingHaSharedStoreWaitForActivation() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        String configStr = firstPart + "<ha-policy><shared-store><master><wait-for-activation>false</wait-for-activation></master></shared-store></ha-policy>" + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration config = parser.parseMainConfig((InputStream)input);
        HAPolicyConfiguration haConfig = config.getHAPolicyConfiguration();
        FileConfigurationParserTest.assertTrue((boolean)(haConfig instanceof SharedStoreMasterPolicyConfiguration));
        SharedStoreMasterPolicyConfiguration masterConfig = (SharedStoreMasterPolicyConfiguration)haConfig;
        FileConfigurationParserTest.assertFalse((boolean)masterConfig.isWaitForActivation());
    }

    @Test
    public void testParsingDefaultServerConfig() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        String configStr = firstPart + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration config = parser.parseMainConfig((InputStream)input);
        String clusterPassword = config.getClusterPassword();
        FileConfigurationParserTest.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultClusterPassword(), (Object)clusterPassword);
        String clusterPasswordPart = "<cluster-password>helloworld</cluster-password>";
        configStr = firstPart + clusterPasswordPart + lastPart;
        config = parser.parseMainConfig((InputStream)new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8)));
        FileConfigurationParserTest.assertEquals((Object)"helloworld", (Object)config.getClusterPassword());
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        String mask = codec.encode((Object)"helloworld");
        String maskPasswordPart = "<mask-password>true</mask-password>";
        clusterPasswordPart = "<cluster-password>" + mask + "</cluster-password>";
        configStr = firstPart + clusterPasswordPart + maskPasswordPart + lastPart;
        config = parser.parseMainConfig((InputStream)new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8)));
        FileConfigurationParserTest.assertEquals((Object)"helloworld", (Object)config.getClusterPassword());
        codec = new DefaultSensitiveStringCodec();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("key", "newkey");
        codec.init(prop);
        mask = codec.encode((Object)"newpassword");
        clusterPasswordPart = "<cluster-password>" + mask + "</cluster-password>";
        String codecPart = "<password-codec>org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;key=newkey</password-codec>";
        configStr = firstPart + clusterPasswordPart + maskPasswordPart + codecPart + lastPart;
        config = parser.parseMainConfig((InputStream)new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8)));
        FileConfigurationParserTest.assertEquals((Object)"newpassword", (Object)config.getClusterPassword());
    }
}

