/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.util.List;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.cluster.ha.ColocatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.LiveOnlyPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicaPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreMasterPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreSlavePolicy;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.ColocatedActivation;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.core.server.impl.LiveOnlyActivation;
import org.apache.activemq.artemis.core.server.impl.SharedNothingBackupActivation;
import org.apache.activemq.artemis.core.server.impl.SharedNothingLiveActivation;
import org.apache.activemq.artemis.core.server.impl.SharedStoreBackupActivation;
import org.apache.activemq.artemis.core.server.impl.SharedStoreLiveActivation;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Test;

public class HAPolicyConfigurationTest
extends ActiveMQTestBase {
    @Test
    public void shouldNotUseJdbcNodeManagerWithoutHAPolicy() throws Exception {
        Configuration configuration = this.createConfiguration("database-store-no-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        HAPolicyConfigurationTest.assertEquals((Object)StoreConfiguration.StoreType.DATABASE, (Object)server.getConfiguration().getStoreConfiguration().getStoreType());
        HAPolicyConfigurationTest.assertEquals((Object)HAPolicyConfiguration.TYPE.LIVE_ONLY, (Object)server.getConfiguration().getHAPolicyConfiguration().getType());
        try {
            server.start();
            HAPolicyConfigurationTest.assertThat((Object)server.getNodeManager(), (Matcher)CoreMatchers.instanceOf(InVMNodeManager.class));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void liveOnlyTest() throws Exception {
        Configuration configuration = this.createConfiguration("live-only-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof LiveOnlyActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof LiveOnlyPolicy));
            LiveOnlyPolicy liveOnlyPolicy = (LiveOnlyPolicy)haPolicy;
            ScaleDownPolicy scaleDownPolicy = liveOnlyPolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)scaleDownPolicy);
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getGroupName(), (Object)"boo!");
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getDiscoveryGroup(), (Object)"wahey");
            List connectors = scaleDownPolicy.getConnectors();
            HAPolicyConfigurationTest.assertNotNull((Object)connectors);
            HAPolicyConfigurationTest.assertEquals((long)connectors.size(), (long)0L);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void liveOnlyTest2() throws Exception {
        Configuration configuration = this.createConfiguration("live-only-hapolicy-config2.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof LiveOnlyActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof LiveOnlyPolicy));
            LiveOnlyPolicy liveOnlyPolicy = (LiveOnlyPolicy)haPolicy;
            ScaleDownPolicy scaleDownPolicy = liveOnlyPolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)scaleDownPolicy);
            HAPolicyConfigurationTest.assertFalse((boolean)scaleDownPolicy.isEnabled());
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getGroupName(), (Object)"boo!");
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getDiscoveryGroup(), null);
            List connectors = scaleDownPolicy.getConnectors();
            HAPolicyConfigurationTest.assertNotNull((Object)connectors);
            HAPolicyConfigurationTest.assertEquals((long)connectors.size(), (long)2L);
            HAPolicyConfigurationTest.assertTrue((boolean)connectors.contains("sd-connector1"));
            HAPolicyConfigurationTest.assertTrue((boolean)connectors.contains("sd-connector2"));
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void liveOnlyTest3() throws Exception {
        this.liveOnlyTest("live-only-hapolicy-config3.xml");
    }

    @Test
    public void liveOnlyTest4() throws Exception {
        this.liveOnlyTest("live-only-hapolicy-config4.xml");
    }

    @Test
    public void liveOnlyTest5() throws Exception {
        this.liveOnlyTest("live-only-hapolicy-config5.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ReplicatedTest() throws Exception {
        Configuration configuration = this.createConfiguration("replicated-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedNothingLiveActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ReplicatedPolicy));
            ReplicatedPolicy replicatedPolicy = (ReplicatedPolicy)haPolicy;
            HAPolicyConfigurationTest.assertEquals((Object)replicatedPolicy.getGroupName(), (Object)"purple");
            HAPolicyConfigurationTest.assertTrue((boolean)replicatedPolicy.isCheckForLiveServer());
            HAPolicyConfigurationTest.assertEquals((Object)replicatedPolicy.getClusterName(), (Object)"abcdefg");
            HAPolicyConfigurationTest.assertEquals((long)replicatedPolicy.getInitialReplicationSyncTimeout(), (long)9876L);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ReplicaTest() throws Exception {
        Configuration configuration = this.createConfiguration("replica-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedNothingBackupActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ReplicaPolicy));
            ReplicaPolicy replicaPolicy = (ReplicaPolicy)haPolicy;
            HAPolicyConfigurationTest.assertEquals((Object)replicaPolicy.getGroupName(), (Object)"tiddles");
            HAPolicyConfigurationTest.assertEquals((long)replicaPolicy.getMaxSavedReplicatedJournalsSize(), (long)22L);
            HAPolicyConfigurationTest.assertEquals((Object)replicaPolicy.getClusterName(), (Object)"33rrrrr");
            HAPolicyConfigurationTest.assertFalse((boolean)replicaPolicy.isRestartBackup());
            HAPolicyConfigurationTest.assertTrue((boolean)replicaPolicy.isAllowFailback());
            HAPolicyConfigurationTest.assertEquals((long)replicaPolicy.getInitialReplicationSyncTimeout(), (long)9876L);
            ScaleDownPolicy scaleDownPolicy = replicaPolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)scaleDownPolicy);
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getGroupName(), (Object)"boo!");
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getDiscoveryGroup(), (Object)"wahey");
            List connectors = scaleDownPolicy.getConnectors();
            HAPolicyConfigurationTest.assertNotNull((Object)connectors);
            HAPolicyConfigurationTest.assertEquals((long)connectors.size(), (long)0L);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ReplicaTest2() throws Exception {
        Configuration configuration = this.createConfiguration("replica-hapolicy-config2.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedNothingBackupActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ReplicaPolicy));
            ReplicaPolicy replicaPolicy = (ReplicaPolicy)haPolicy;
            HAPolicyConfigurationTest.assertEquals((Object)replicaPolicy.getGroupName(), (Object)"tiddles");
            HAPolicyConfigurationTest.assertEquals((long)replicaPolicy.getMaxSavedReplicatedJournalsSize(), (long)22L);
            HAPolicyConfigurationTest.assertEquals((Object)replicaPolicy.getClusterName(), (Object)"33rrrrr");
            HAPolicyConfigurationTest.assertFalse((boolean)replicaPolicy.isRestartBackup());
            ScaleDownPolicy scaleDownPolicy = replicaPolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)scaleDownPolicy);
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getGroupName(), (Object)"boo!");
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getDiscoveryGroup(), null);
            List connectors = scaleDownPolicy.getConnectors();
            HAPolicyConfigurationTest.assertNotNull((Object)connectors);
            HAPolicyConfigurationTest.assertEquals((long)connectors.size(), (long)2L);
            HAPolicyConfigurationTest.assertTrue((boolean)connectors.contains("sd-connector1"));
            HAPolicyConfigurationTest.assertTrue((boolean)connectors.contains("sd-connector2"));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ReplicaTest3() throws Exception {
        Configuration configuration = this.createConfiguration("replica-hapolicy-config3.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedNothingBackupActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ReplicaPolicy));
            ReplicaPolicy replicaPolicy = (ReplicaPolicy)haPolicy;
            HAPolicyConfigurationTest.assertEquals((Object)replicaPolicy.getGroupName(), (Object)"tiddles");
            HAPolicyConfigurationTest.assertEquals((long)replicaPolicy.getMaxSavedReplicatedJournalsSize(), (long)22L);
            HAPolicyConfigurationTest.assertEquals((Object)replicaPolicy.getClusterName(), (Object)"33rrrrr");
            HAPolicyConfigurationTest.assertFalse((boolean)replicaPolicy.isRestartBackup());
            ScaleDownPolicy scaleDownPolicy = replicaPolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNull((Object)scaleDownPolicy);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void SharedStoreMasterTest() throws Exception {
        Configuration configuration = this.createConfiguration("shared-store-master-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedStoreLiveActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof SharedStoreMasterPolicy));
            SharedStoreMasterPolicy masterPolicy = (SharedStoreMasterPolicy)haPolicy;
            HAPolicyConfigurationTest.assertFalse((boolean)masterPolicy.isFailoverOnServerShutdown());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void SharedStoreSlaveTest() throws Exception {
        Configuration configuration = this.createConfiguration("shared-store-slave-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedStoreBackupActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof SharedStoreSlavePolicy));
            SharedStoreSlavePolicy sharedStoreSlavePolicy = (SharedStoreSlavePolicy)haPolicy;
            HAPolicyConfigurationTest.assertFalse((boolean)sharedStoreSlavePolicy.isFailoverOnServerShutdown());
            HAPolicyConfigurationTest.assertFalse((boolean)sharedStoreSlavePolicy.isRestartBackup());
            ScaleDownPolicy scaleDownPolicy = sharedStoreSlavePolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)scaleDownPolicy);
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getGroupName(), (Object)"boo!");
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getDiscoveryGroup(), (Object)"wahey");
            List connectors = scaleDownPolicy.getConnectors();
            HAPolicyConfigurationTest.assertNotNull((Object)connectors);
            HAPolicyConfigurationTest.assertEquals((long)connectors.size(), (long)0L);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void SharedStoreSlaveTest2() throws Exception {
        Configuration configuration = this.createConfiguration("shared-store-slave-hapolicy-config2.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedStoreBackupActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof SharedStoreSlavePolicy));
            SharedStoreSlavePolicy sharedStoreSlavePolicy = (SharedStoreSlavePolicy)haPolicy;
            HAPolicyConfigurationTest.assertTrue((boolean)sharedStoreSlavePolicy.isFailoverOnServerShutdown());
            HAPolicyConfigurationTest.assertTrue((boolean)sharedStoreSlavePolicy.isRestartBackup());
            ScaleDownPolicy scaleDownPolicy = sharedStoreSlavePolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)scaleDownPolicy);
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getGroupName(), (Object)"boo!");
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getDiscoveryGroup(), null);
            List connectors = scaleDownPolicy.getConnectors();
            HAPolicyConfigurationTest.assertNotNull((Object)connectors);
            HAPolicyConfigurationTest.assertEquals((long)connectors.size(), (long)2L);
            HAPolicyConfigurationTest.assertTrue((boolean)connectors.contains("sd-connector1"));
            HAPolicyConfigurationTest.assertTrue((boolean)connectors.contains("sd-connector2"));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void SharedStoreSlaveTest3() throws Exception {
        Configuration configuration = this.createConfiguration("shared-store-slave-hapolicy-config3.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedStoreBackupActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof SharedStoreSlavePolicy));
            SharedStoreSlavePolicy sharedStoreSlavePolicy = (SharedStoreSlavePolicy)haPolicy;
            HAPolicyConfigurationTest.assertTrue((boolean)sharedStoreSlavePolicy.isFailoverOnServerShutdown());
            HAPolicyConfigurationTest.assertTrue((boolean)sharedStoreSlavePolicy.isRestartBackup());
            ScaleDownPolicy scaleDownPolicy = sharedStoreSlavePolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNull((Object)scaleDownPolicy);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void colocatedTest() throws Exception {
        Configuration configuration = this.createConfiguration("colocated-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof ColocatedActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ColocatedPolicy));
            ColocatedPolicy colocatedPolicy = (ColocatedPolicy)haPolicy;
            ReplicatedPolicy livePolicy = (ReplicatedPolicy)colocatedPolicy.getLivePolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)livePolicy);
            HAPolicyConfigurationTest.assertEquals((Object)livePolicy.getGroupName(), (Object)"purple");
            HAPolicyConfigurationTest.assertTrue((boolean)livePolicy.isCheckForLiveServer());
            HAPolicyConfigurationTest.assertEquals((Object)livePolicy.getClusterName(), (Object)"abcdefg");
            ReplicaPolicy backupPolicy = (ReplicaPolicy)colocatedPolicy.getBackupPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)backupPolicy);
            HAPolicyConfigurationTest.assertEquals((Object)backupPolicy.getGroupName(), (Object)"tiddles");
            HAPolicyConfigurationTest.assertEquals((long)backupPolicy.getMaxSavedReplicatedJournalsSize(), (long)22L);
            HAPolicyConfigurationTest.assertEquals((Object)backupPolicy.getClusterName(), (Object)"33rrrrr");
            HAPolicyConfigurationTest.assertFalse((boolean)backupPolicy.isRestartBackup());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void colocatedTestNullBackup() throws Exception {
        Configuration configuration = this.createConfiguration("colocated-hapolicy-config-null-backup.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof ColocatedActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ColocatedPolicy));
            ColocatedPolicy colocatedPolicy = (ColocatedPolicy)haPolicy;
            ReplicatedPolicy livePolicy = (ReplicatedPolicy)colocatedPolicy.getLivePolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)livePolicy);
            HAPolicyConfigurationTest.assertEquals((Object)livePolicy.getGroupName(), (Object)"purple");
            HAPolicyConfigurationTest.assertTrue((boolean)livePolicy.isCheckForLiveServer());
            HAPolicyConfigurationTest.assertEquals((Object)livePolicy.getClusterName(), (Object)"abcdefg");
            ReplicaPolicy backupPolicy = (ReplicaPolicy)colocatedPolicy.getBackupPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)backupPolicy);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void colocatedTest2() throws Exception {
        Configuration configuration = this.createConfiguration("colocated-hapolicy-config2.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof ColocatedActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ColocatedPolicy));
            ColocatedPolicy colocatedPolicy = (ColocatedPolicy)haPolicy;
            SharedStoreMasterPolicy livePolicy = (SharedStoreMasterPolicy)colocatedPolicy.getLivePolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)livePolicy);
            HAPolicyConfigurationTest.assertFalse((boolean)livePolicy.isFailoverOnServerShutdown());
            SharedStoreSlavePolicy backupPolicy = (SharedStoreSlavePolicy)colocatedPolicy.getBackupPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)backupPolicy);
            HAPolicyConfigurationTest.assertFalse((boolean)backupPolicy.isFailoverOnServerShutdown());
            HAPolicyConfigurationTest.assertFalse((boolean)backupPolicy.isRestartBackup());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void colocatedTest2nullbackup() throws Exception {
        Configuration configuration = this.createConfiguration("colocated-hapolicy-config2-null-backup.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof ColocatedActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ColocatedPolicy));
            ColocatedPolicy colocatedPolicy = (ColocatedPolicy)haPolicy;
            SharedStoreMasterPolicy livePolicy = (SharedStoreMasterPolicy)colocatedPolicy.getLivePolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)livePolicy);
            HAPolicyConfigurationTest.assertFalse((boolean)livePolicy.isFailoverOnServerShutdown());
            SharedStoreSlavePolicy backupPolicy = (SharedStoreSlavePolicy)colocatedPolicy.getBackupPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)backupPolicy);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void liveOnlyTest(String file) throws Exception {
        Configuration configuration = this.createConfiguration(file);
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof LiveOnlyActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof LiveOnlyPolicy));
            LiveOnlyPolicy liveOnlyPolicy = (LiveOnlyPolicy)haPolicy;
            ScaleDownPolicy scaleDownPolicy = liveOnlyPolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNull((Object)scaleDownPolicy);
        }
        finally {
            server.stop();
        }
    }

    protected Configuration createConfiguration(String fileName) throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(fileName);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        fc.setPagingDirectory(this.getTestDir() + "/" + fc.getPagingDirectory());
        fc.setLargeMessagesDirectory(this.getTestDir() + "/" + fc.getLargeMessagesDirectory());
        fc.setJournalDirectory(this.getTestDir() + "/" + fc.getJournalDirectory());
        fc.setBindingsDirectory(this.getTestDir() + "/" + fc.getBindingsDirectory());
        return fc;
    }
}

