/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.util.UUID;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcSharedStateManager;
import org.apache.activemq.artemis.core.server.impl.jdbc.TestJDBCDriver;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class JdbcSharedStateManagerTest
extends ActiveMQTestBase {
    private DatabaseStorageConfiguration dbConf;
    private SQLProvider sqlProvider;

    @Before
    public void configure() {
        this.dbConf = this.createDefaultDatabaseStorageConfiguration();
        this.sqlProvider = JDBCUtils.getSQLProvider((String)this.dbConf.getJdbcDriverClassName(), (String)this.dbConf.getNodeManagerStoreTableName(), (SQLProvider.DatabaseStoreType)SQLProvider.DatabaseStoreType.NODE_MANAGER);
    }

    private TestJDBCDriver createFakeDriver(boolean initializeTable) {
        return TestJDBCDriver.usingConnectionUrl(this.dbConf.getJdbcConnectionUrl(), this.dbConf.getJdbcDriverClassName(), this.sqlProvider, initializeTable);
    }

    private JdbcSharedStateManager createSharedStateManager() {
        return JdbcSharedStateManager.usingConnectionUrl((String)UUID.randomUUID().toString(), (long)this.dbConf.getJdbcLockExpirationMillis(), (String)this.dbConf.getJdbcConnectionUrl(), (String)this.dbConf.getJdbcDriverClassName(), (SQLProvider)this.sqlProvider);
    }

    @Test(timeout=10000L)
    public void shouldStartIfTableNotExist() throws Exception {
        JdbcSharedStateManager sharedStateManager = this.createSharedStateManager();
        try {
            sharedStateManager.destroy();
        }
        finally {
            sharedStateManager.stop();
        }
    }

    @Test(timeout=10000L)
    public void shouldStartIfTableExistEmpty() throws Exception {
        TestJDBCDriver fakeDriver = this.createFakeDriver(false);
        fakeDriver.start();
        JdbcSharedStateManager sharedStateManager = this.createSharedStateManager();
        sharedStateManager.stop();
        try {
            fakeDriver.destroy();
        }
        finally {
            fakeDriver.stop();
        }
    }

    @Test(timeout=10000L)
    public void shouldStartIfTableExistInitialized() throws Exception {
        TestJDBCDriver fakeDriver = this.createFakeDriver(true);
        fakeDriver.start();
        JdbcSharedStateManager sharedStateManager = this.createSharedStateManager();
        sharedStateManager.stop();
        try {
            fakeDriver.destroy();
        }
        finally {
            fakeDriver.stop();
        }
    }

    @Test(timeout=10000L)
    public void shouldStartTwoIfTableNotExist() throws Exception {
        JdbcSharedStateManager liveSharedStateManager = this.createSharedStateManager();
        JdbcSharedStateManager backupSharedStateManager = this.createSharedStateManager();
        backupSharedStateManager.stop();
        try {
            liveSharedStateManager.destroy();
        }
        finally {
            liveSharedStateManager.stop();
        }
    }
}

