/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.sql.SQLException;
import org.apache.activemq.artemis.jdbc.store.drivers.AbstractJDBCDriver;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.junit.Assert;

public class TestJDBCDriver
extends AbstractJDBCDriver {
    private boolean initialize;

    public static TestJDBCDriver usingConnectionUrl(String jdbcConnectionUrl, String jdbcDriverClass, SQLProvider provider) {
        return TestJDBCDriver.usingConnectionUrl(jdbcConnectionUrl, jdbcDriverClass, provider, false);
    }

    public static TestJDBCDriver usingConnectionUrl(String jdbcConnectionUrl, String jdbcDriverClass, SQLProvider provider, boolean initialize) {
        TestJDBCDriver driver = new TestJDBCDriver(initialize);
        driver.setSqlProvider(provider);
        driver.setJdbcConnectionUrl(jdbcConnectionUrl);
        driver.setJdbcDriverClass(jdbcDriverClass);
        return driver;
    }

    private TestJDBCDriver(boolean initialize) {
        this.initialize = initialize;
    }

    protected void prepareStatements() throws SQLException {
    }

    protected void createSchema() throws SQLException {
        try {
            this.connection.createStatement().execute(this.sqlProvider.createNodeManagerStoreTableSQL());
            if (this.initialize) {
                this.connection.createStatement().execute(this.sqlProvider.createNodeIdSQL());
                this.connection.createStatement().execute(this.sqlProvider.createStateSQL());
                this.connection.createStatement().execute(this.sqlProvider.createLiveLockSQL());
                this.connection.createStatement().execute(this.sqlProvider.createBackupLockSQL());
            }
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

