/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.junit;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.junit.AbstractActiveMQProducerResource;
import org.apache.activemq.junit.EmbeddedActiveMQBroker;

public class ActiveMQDynamicQueueSenderResource
extends AbstractActiveMQProducerResource {
    public ActiveMQDynamicQueueSenderResource(ActiveMQConnectionFactory connectionFactory) {
        super(connectionFactory);
    }

    public ActiveMQDynamicQueueSenderResource(URI brokerURI) {
        super(brokerURI);
    }

    public ActiveMQDynamicQueueSenderResource(EmbeddedActiveMQBroker embeddedActiveMQBroker) {
        super(embeddedActiveMQBroker);
    }

    public ActiveMQDynamicQueueSenderResource(URI brokerURI, String userName, String password) {
        super(brokerURI, userName, password);
    }

    public ActiveMQDynamicQueueSenderResource(String defaultDestinationName, ActiveMQConnectionFactory connectionFactory) {
        super(defaultDestinationName, connectionFactory);
    }

    public ActiveMQDynamicQueueSenderResource(String defaultDestinationName, URI brokerURI) {
        super(defaultDestinationName, brokerURI);
    }

    public ActiveMQDynamicQueueSenderResource(String destinationName, EmbeddedActiveMQBroker embeddedActiveMQBroker) {
        super(destinationName, embeddedActiveMQBroker);
    }

    public ActiveMQDynamicQueueSenderResource(String defaultDestinationName, URI brokerURI, String userName, String password) {
        super(defaultDestinationName, brokerURI, userName, password);
    }

    @Override
    protected void createClient() throws JMSException {
        this.producer = this.session.createProducer(null);
    }

    @Override
    public byte getDestinationType() {
        return 1;
    }

    @Override
    public void sendMessage(Message message) throws JMSException {
        if (this.destination == null) {
            throw new IllegalStateException("Destination is not specified");
        }
        this.producer.send((Destination)this.destination, message);
    }

    public void sendMessage(String destinationName, Message message) throws JMSException {
        this.producer.send((Destination)this.createDestination(destinationName), message);
    }

    public BytesMessage sendMessage(String destinationName, byte[] body) throws JMSException {
        BytesMessage message = this.createMessage(body);
        this.sendMessage(destinationName, (Message)message);
        return message;
    }

    public TextMessage sendMessage(String destinationName, String body) throws JMSException {
        TextMessage message = this.createMessage(body);
        this.sendMessage(destinationName, (Message)message);
        return message;
    }

    public MapMessage sendMessage(String destinationName, Map<String, Object> body) throws JMSException {
        MapMessage message = this.createMessage(body);
        this.sendMessage(destinationName, (Message)message);
        return message;
    }

    public ObjectMessage sendMessage(String destinationName, Serializable body) throws JMSException {
        ObjectMessage message = this.createMessage(body);
        this.sendMessage(destinationName, (Message)message);
        return message;
    }

    public BytesMessage sendMessageWithProperties(String destinationName, byte[] body, Map<String, Object> properties) throws JMSException {
        BytesMessage message = this.createMessage(body, properties);
        this.sendMessage(destinationName, (Message)message);
        return message;
    }

    public TextMessage sendMessageWithProperties(String destinationName, String body, Map<String, Object> properties) throws JMSException {
        TextMessage message = this.createMessage(body, properties);
        this.sendMessage(destinationName, (Message)message);
        return message;
    }

    public MapMessage sendMessageWithProperties(String destinationName, Map<String, Object> body, Map<String, Object> properties) throws JMSException {
        MapMessage message = this.createMessage(body, properties);
        this.sendMessage(destinationName, (Message)message);
        return message;
    }

    public ObjectMessage sendMessageWithProperties(String destinationName, Serializable body, Map<String, Object> properties) throws JMSException {
        ObjectMessage message = this.createMessage(body, properties);
        this.sendMessage(destinationName, (Message)message);
        return message;
    }
}

