/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

abstract class ConfigManagerBase
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin {
    private static final long serialVersionUID = -6691093960031418130L;
    private static final String CONFIGURATION_ADMIN_NAME = ConfigurationAdmin.class.getName();
    private static final String META_TYPE_NAME = MetaTypeService.class.getName();
    private static final IdGetter PID_GETTER = new IdGetter(){

        public String[] getIds(MetaTypeInformation metaTypeInformation) {
            return metaTypeInformation.getPids();
        }
    };
    private static final IdGetter FACTORY_PID_GETTER = new IdGetter(){

        public String[] getIds(MetaTypeInformation metaTypeInformation) {
            return metaTypeInformation.getFactoryPids();
        }
    };

    ConfigManagerBase(String label, String title, String[] css) {
        super(label, title, css);
    }

    protected ConfigurationAdmin getConfigurationAdmin() {
        return (ConfigurationAdmin)this.getService(CONFIGURATION_ADMIN_NAME);
    }

    protected MetaTypeService getMetaTypeService() {
        return (MetaTypeService)this.getService(META_TYPE_NAME);
    }

    protected Map getPidObjectClasses(String locale) {
        return this.getObjectClassDefinitions(PID_GETTER, locale);
    }

    protected Map getFactoryPidObjectClasses(String locale) {
        return this.getObjectClassDefinitions(FACTORY_PID_GETTER, locale);
    }

    private Map getObjectClassDefinitions(IdGetter idGetter, String locale) {
        HashMap<String, ObjectClassDefinition> objectClassesDefinitions = new HashMap<String, ObjectClassDefinition>();
        MetaTypeService mts = this.getMetaTypeService();
        if (mts != null) {
            Bundle[] bundles = this.getBundleContext().getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                MetaTypeInformation mti = mts.getMetaTypeInformation(bundles[i]);
                if (mti == null) continue;
                String[] idList = idGetter.getIds(mti);
                for (int j = 0; idList != null && j < idList.length; ++j) {
                    ObjectClassDefinition ocd = null;
                    try {
                        ocd = mti.getObjectClassDefinition(idList[j], locale);
                    }
                    catch (IllegalArgumentException ignore) {
                        // empty catch block
                    }
                    if (ocd == null) continue;
                    objectClassesDefinitions.put(idList[j], ocd);
                }
            }
        }
        return objectClassesDefinitions;
    }

    protected ObjectClassDefinition getObjectClassDefinition(Configuration config, String locale) {
        MetaTypeInformation mti;
        MetaTypeService mts;
        Bundle bundle;
        if (config.getBundleLocation() != null && (bundle = this.getBundle(config.getBundleLocation())) != null && (mts = this.getMetaTypeService()) != null && (mti = mts.getMetaTypeInformation(bundle)) != null) {
            if (config.getFactoryPid() != null) {
                return mti.getObjectClassDefinition(config.getFactoryPid(), locale);
            }
            return mti.getObjectClassDefinition(config.getPid(), locale);
        }
        if (config.getFactoryPid() != null) {
            return this.getObjectClassDefinition(config.getFactoryPid(), locale);
        }
        return this.getObjectClassDefinition(config.getPid(), locale);
    }

    protected ObjectClassDefinition getObjectClassDefinition(Bundle bundle, String pid, String locale) {
        MetaTypeInformation mti;
        MetaTypeService mts;
        if (bundle != null && (mts = this.getMetaTypeService()) != null && (mti = mts.getMetaTypeInformation(bundle)) != null) {
            try {
                return mti.getObjectClassDefinition(pid, locale);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected ObjectClassDefinition getObjectClassDefinition(String pid, String locale) {
        Bundle[] bundles = this.getBundleContext().getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            try {
                ObjectClassDefinition ocd = this.getObjectClassDefinition(bundles[i], pid, locale);
                if (ocd == null) continue;
                return ocd;
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        return null;
    }

    protected Map getAttributeDefinitionMap(Configuration config, String locale) {
        AttributeDefinition[] ad;
        HashMap<String, AttributeDefinition> adMap = new HashMap<String, AttributeDefinition>();
        ObjectClassDefinition ocd = this.getObjectClassDefinition(config, locale);
        if (ocd != null && (ad = ocd.getAttributeDefinitions(-1)) != null) {
            for (int i = 0; i < ad.length; ++i) {
                adMap.put(ad[i].getID(), ad[i]);
            }
        }
        return adMap;
    }

    protected Bundle getBundle(String bundleLocation) {
        if (bundleLocation == null) {
            return null;
        }
        Bundle[] bundles = this.getBundleContext().getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            if (!bundleLocation.equals(bundles[i].getLocation())) continue;
            return bundles[i];
        }
        return null;
    }

    protected Locale getLocale(HttpServletRequest request) {
        try {
            return request.getLocale();
        }
        catch (Throwable t) {
            return Locale.getDefault();
        }
    }

    private static interface IdGetter {
        public String[] getIds(MetaTypeInformation var1);
    }
}

