/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.felix.webconsole.internal.core;


import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;


/**
 * The <code>LogoutServlet</code> provides the logout screen and functionality.
 */
public class LogoutServlet extends SimpleWebConsolePlugin
{

    /** the label of the logout plugin - used by other plugins to reference to plugin details */
    public static final String NAME = "logout";
    private static final String TITLE = "%logout.pluginTitle";

    // templates
    private final String TEMPLATE_MAIN;

    /** Default constructor */
    public LogoutServlet()
    {
        super(NAME, TITLE, null);

        // load templates
        TEMPLATE_MAIN = readTemplateFile( "/templates/logout.html" );
    }

    //---------- BaseWebConsolePlugin

    /**
     * @see org.apache.felix.webconsole.AbstractWebConsolePlugin#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    protected void doGet( HttpServletRequest request, HttpServletResponse response ) throws ServletException, IOException
    {
        // not calling super.doGet() because we're rendering a partial page, so we have to set these bits ourselves here
        response.setCharacterEncoding("utf-8"); //$NON-NLS-1$
        response.setContentType( "text/html" ); //$NON-NLS-1$

        renderContent(request, response);
    }

    /**
     * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    protected void doPost( HttpServletRequest request, HttpServletResponse response ) throws ServletException, IOException
    {
        OsgiManager.logout(request);
        response.setContentLength( 0 );
    }

    /**
     * @see org.apache.felix.webconsole.AbstractWebConsolePlugin#renderContent(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    protected void renderContent( HttpServletRequest request, HttpServletResponse response ) throws IOException, ServletException
    {
        response.getWriter().print(TEMPLATE_MAIN);
    }

}
